/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Consumer;
import org.springframework.aot.generate.AccessVisibility;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodGenerator;
import org.springframework.aot.hint.ExecutableHint;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.beans.factory.aot.AutowiredArgumentsCodeGenerator;
import org.springframework.beans.factory.aot.AutowiredInstantiationArgumentsResolver;
import org.springframework.beans.factory.support.InstanceSupplier;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.util.ClassUtils;
import org.springframework.util.function.ThrowingSupplier;

class InstanceSupplierCodeGenerator {
    private static final String REGISTERED_BEAN_PARAMETER_NAME = "registeredBean";
    private static final javax.lang.model.element.Modifier[] PRIVATE_STATIC = new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PRIVATE, javax.lang.model.element.Modifier.STATIC};
    private static final CodeBlock NO_ARGS = CodeBlock.of((String)"", (Object[])new Object[0]);
    private static final Consumer<ExecutableHint.Builder> INTROSPECT = builder -> builder.withMode(ExecutableMode.INTROSPECT);
    private final GenerationContext generationContext;
    private final ClassName className;
    private final MethodGenerator methodGenerator;
    private final boolean allowDirectSupplierShortcut;

    InstanceSupplierCodeGenerator(GenerationContext generationContext, ClassName className, MethodGenerator methodGenerator, boolean allowDirectSupplierShortcut) {
        this.generationContext = generationContext;
        this.className = className;
        this.methodGenerator = methodGenerator;
        this.allowDirectSupplierShortcut = allowDirectSupplierShortcut;
    }

    CodeBlock generateCode(RegisteredBean registeredBean, Executable constructorOrFactoryMethod) {
        if (constructorOrFactoryMethod instanceof Constructor) {
            Constructor constructor = (Constructor)constructorOrFactoryMethod;
            return this.generateCodeForConstructor(registeredBean, constructor);
        }
        if (constructorOrFactoryMethod instanceof Method) {
            Method method = (Method)constructorOrFactoryMethod;
            return this.generateCodeForFactoryMethod(registeredBean, method);
        }
        throw new IllegalStateException("No suitable executor found for " + registeredBean.getBeanName());
    }

    private CodeBlock generateCodeForConstructor(RegisteredBean registeredBean, Constructor<?> constructor) {
        String name = registeredBean.getBeanName();
        Class declaringClass = ClassUtils.getUserClass(constructor.getDeclaringClass());
        boolean dependsOnBean = ClassUtils.isInnerClass((Class)declaringClass);
        AccessVisibility accessVisibility = this.getAccessVisibility(registeredBean, constructor);
        if (accessVisibility == AccessVisibility.PUBLIC || accessVisibility == AccessVisibility.PACKAGE_PRIVATE) {
            return this.generateCodeForAccessibleConstructor(name, constructor, declaringClass, dependsOnBean);
        }
        return this.generateCodeForInaccessibleConstructor(name, constructor, declaringClass, dependsOnBean);
    }

    private CodeBlock generateCodeForAccessibleConstructor(String name, Constructor<?> constructor, Class<?> declaringClass, boolean dependsOnBean) {
        this.generationContext.getRuntimeHints().reflection().registerConstructor(constructor, INTROSPECT);
        if (!dependsOnBean && constructor.getParameterCount() == 0) {
            if (!this.allowDirectSupplierShortcut) {
                return CodeBlock.of((String)"$T.using($T::new)", (Object[])new Object[]{InstanceSupplier.class, declaringClass});
            }
            if (!this.isThrowingCheckedException(constructor)) {
                return CodeBlock.of((String)"$T::new", (Object[])new Object[]{declaringClass});
            }
            return CodeBlock.of((String)"$T.of($T::new)", (Object[])new Object[]{ThrowingSupplier.class, declaringClass});
        }
        GeneratedMethod getInstanceMethod = this.generateGetInstanceMethod().using(builder -> this.buildGetInstanceMethodForConstructor((MethodSpec.Builder)builder, name, constructor, declaringClass, dependsOnBean, PRIVATE_STATIC));
        return CodeBlock.of((String)"$T.of($T::$L)", (Object[])new Object[]{InstanceSupplier.class, this.className, getInstanceMethod.getName()});
    }

    private CodeBlock generateCodeForInaccessibleConstructor(String name, Constructor<?> constructor, Class<?> declaringClass, boolean dependsOnBean) {
        this.generationContext.getRuntimeHints().reflection().registerConstructor(constructor);
        GeneratedMethod getInstanceMethod = this.generateGetInstanceMethod().using(builder -> {
            builder.addJavadoc("Instantiate the bean instance for '$L'.", new Object[]{name});
            builder.addModifiers(PRIVATE_STATIC);
            builder.returns((Type)declaringClass);
            builder.addParameter(RegisteredBean.class, REGISTERED_BEAN_PARAMETER_NAME, new javax.lang.model.element.Modifier[0]);
            int parameterOffset = !dependsOnBean ? 0 : 1;
            builder.addStatement(this.generateResolverForConstructor(constructor, parameterOffset));
            builder.addStatement("return resolver.resolveAndInstantiate($L)", new Object[]{REGISTERED_BEAN_PARAMETER_NAME});
        });
        return CodeBlock.of((String)"$T.of($T::$L)", (Object[])new Object[]{InstanceSupplier.class, this.className, getInstanceMethod.getName()});
    }

    private void buildGetInstanceMethodForConstructor(MethodSpec.Builder builder, String name, Constructor<?> constructor, Class<?> declaringClass, boolean dependsOnBean, javax.lang.model.element.Modifier ... modifiers) {
        builder.addJavadoc("Create the bean instance for '$L'.", new Object[]{name});
        builder.addModifiers(modifiers);
        builder.returns(declaringClass);
        builder.addParameter(RegisteredBean.class, REGISTERED_BEAN_PARAMETER_NAME, new javax.lang.model.element.Modifier[0]);
        if (constructor.getParameterCount() == 0) {
            CodeBlock instantiationCode = this.generateNewInstanceCodeForConstructor(dependsOnBean, declaringClass, NO_ARGS);
            builder.addCode(this.generateReturnStatement(instantiationCode));
        } else {
            int parameterOffset = !dependsOnBean ? 0 : 1;
            CodeBlock.Builder code = CodeBlock.builder();
            code.addStatement(this.generateResolverForConstructor(constructor, parameterOffset));
            CodeBlock arguments = new AutowiredArgumentsCodeGenerator(declaringClass, constructor).generateCode(constructor.getParameterTypes(), parameterOffset);
            CodeBlock newInstance = this.generateNewInstanceCodeForConstructor(dependsOnBean, declaringClass, arguments);
            code.addStatement("return resolver.resolve($L, (args) -> $L)", new Object[]{REGISTERED_BEAN_PARAMETER_NAME, newInstance});
            builder.addCode(code.build());
        }
    }

    private CodeBlock generateResolverForConstructor(Constructor<?> constructor, int parameterOffset) {
        CodeBlock parameterTypes = this.generateParameterTypesCode(constructor.getParameterTypes(), parameterOffset);
        return CodeBlock.of((String)"$T resolver = $T.forConstructor($L)", (Object[])new Object[]{AutowiredInstantiationArgumentsResolver.class, AutowiredInstantiationArgumentsResolver.class, parameterTypes});
    }

    private CodeBlock generateNewInstanceCodeForConstructor(boolean dependsOnBean, Class<?> declaringClass, CodeBlock args) {
        if (!dependsOnBean) {
            return CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{declaringClass, args});
        }
        return CodeBlock.of((String)"$L.getBeanFactory().getBean($T.class).new $L($L)", (Object[])new Object[]{REGISTERED_BEAN_PARAMETER_NAME, declaringClass.getEnclosingClass(), declaringClass.getSimpleName(), args});
    }

    private CodeBlock generateCodeForFactoryMethod(RegisteredBean registeredBean, Method factoryMethod) {
        String name = registeredBean.getBeanName();
        Class declaringClass = ClassUtils.getUserClass(factoryMethod.getDeclaringClass());
        boolean dependsOnBean = !Modifier.isStatic(factoryMethod.getModifiers());
        AccessVisibility accessVisibility = this.getAccessVisibility(registeredBean, factoryMethod);
        if (accessVisibility == AccessVisibility.PUBLIC || accessVisibility == AccessVisibility.PACKAGE_PRIVATE) {
            return this.generateCodeForAccessibleFactoryMethod(name, factoryMethod, declaringClass, dependsOnBean);
        }
        return this.generateCodeForInaccessibleFactoryMethod(name, factoryMethod, declaringClass);
    }

    private CodeBlock generateCodeForAccessibleFactoryMethod(String name, Method factoryMethod, Class<?> declaringClass, boolean dependsOnBean) {
        this.generationContext.getRuntimeHints().reflection().registerMethod(factoryMethod, INTROSPECT);
        if (!dependsOnBean && factoryMethod.getParameterCount() == 0) {
            if (!this.allowDirectSupplierShortcut) {
                return CodeBlock.of((String)"$T.using($T::$L)", (Object[])new Object[]{InstanceSupplier.class, declaringClass, factoryMethod.getName()});
            }
            if (!this.isThrowingCheckedException(factoryMethod)) {
                return CodeBlock.of((String)"$T::$L", (Object[])new Object[]{declaringClass, factoryMethod.getName()});
            }
            return CodeBlock.of((String)"$T.of($T::$L)", (Object[])new Object[]{ThrowingSupplier.class, declaringClass, factoryMethod.getName()});
        }
        GeneratedMethod getInstanceMethod = this.generateGetInstanceMethod().using(builder -> this.buildGetInstanceMethodForFactoryMethod((MethodSpec.Builder)builder, name, factoryMethod, declaringClass, dependsOnBean, PRIVATE_STATIC));
        return CodeBlock.of((String)"$T.of($T::$L)", (Object[])new Object[]{InstanceSupplier.class, this.className, getInstanceMethod.getName()});
    }

    private CodeBlock generateCodeForInaccessibleFactoryMethod(String name, Method factoryMethod, Class<?> declaringClass) {
        this.generationContext.getRuntimeHints().reflection().registerMethod(factoryMethod);
        GeneratedMethod getInstanceMethod = this.generateGetInstanceMethod().using(builder -> {
            builder.addJavadoc("Instantiate the bean instance for '$L'.", new Object[]{name});
            builder.addModifiers(PRIVATE_STATIC);
            builder.returns(factoryMethod.getReturnType());
            builder.addParameter(RegisteredBean.class, REGISTERED_BEAN_PARAMETER_NAME, new javax.lang.model.element.Modifier[0]);
            builder.addStatement(this.generateResolverForFactoryMethod(factoryMethod, declaringClass, factoryMethod.getName()));
            builder.addStatement("return resolver.resolveAndInstantiate($L)", new Object[]{REGISTERED_BEAN_PARAMETER_NAME});
        });
        return CodeBlock.of((String)"$T.of($T::$L)", (Object[])new Object[]{InstanceSupplier.class, this.className, getInstanceMethod.getName()});
    }

    private void buildGetInstanceMethodForFactoryMethod(MethodSpec.Builder builder, String name, Method factoryMethod, Class<?> declaringClass, boolean dependsOnBean, javax.lang.model.element.Modifier ... modifiers) {
        String factoryMethodName = factoryMethod.getName();
        builder.addJavadoc("Get the bean instance for '$L'.", new Object[]{name});
        builder.addModifiers(modifiers);
        builder.returns(factoryMethod.getReturnType());
        if (this.isThrowingCheckedException(factoryMethod)) {
            builder.addException(Exception.class);
        }
        builder.addParameter(RegisteredBean.class, REGISTERED_BEAN_PARAMETER_NAME, new javax.lang.model.element.Modifier[0]);
        if (factoryMethod.getParameterCount() == 0) {
            CodeBlock instantiationCode = this.generateNewInstanceCodeForMethod(dependsOnBean, declaringClass, factoryMethodName, NO_ARGS);
            builder.addCode(this.generateReturnStatement(instantiationCode));
        } else {
            CodeBlock.Builder code = CodeBlock.builder();
            code.addStatement(this.generateResolverForFactoryMethod(factoryMethod, declaringClass, factoryMethodName));
            CodeBlock arguments = new AutowiredArgumentsCodeGenerator(declaringClass, factoryMethod).generateCode(factoryMethod.getParameterTypes());
            CodeBlock newInstance = this.generateNewInstanceCodeForMethod(dependsOnBean, declaringClass, factoryMethodName, arguments);
            code.addStatement("return resolver.resolve($L, (args) -> $L)", new Object[]{REGISTERED_BEAN_PARAMETER_NAME, newInstance});
            builder.addCode(code.build());
        }
    }

    private CodeBlock generateResolverForFactoryMethod(Method factoryMethod, Class<?> declaringClass, String factoryMethodName) {
        if (factoryMethod.getParameterCount() == 0) {
            return CodeBlock.of((String)"$T resolver = $T.forFactoryMethod($T.class, $S)", (Object[])new Object[]{AutowiredInstantiationArgumentsResolver.class, AutowiredInstantiationArgumentsResolver.class, declaringClass, factoryMethodName});
        }
        CodeBlock parameterTypes = this.generateParameterTypesCode(factoryMethod.getParameterTypes(), 0);
        return CodeBlock.of((String)"$T resolver = $T.forFactoryMethod($T.class, $S, $L)", (Object[])new Object[]{AutowiredInstantiationArgumentsResolver.class, AutowiredInstantiationArgumentsResolver.class, declaringClass, factoryMethodName, parameterTypes});
    }

    private CodeBlock generateNewInstanceCodeForMethod(boolean dependsOnBean, Class<?> declaringClass, String factoryMethodName, CodeBlock args) {
        if (!dependsOnBean) {
            return CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{declaringClass, factoryMethodName, args});
        }
        return CodeBlock.of((String)"$L.getBeanFactory().getBean($T.class).$L($L)", (Object[])new Object[]{REGISTERED_BEAN_PARAMETER_NAME, declaringClass, factoryMethodName, args});
    }

    private CodeBlock generateReturnStatement(CodeBlock instantiationCode) {
        CodeBlock.Builder code = CodeBlock.builder();
        code.addStatement("return $L", new Object[]{instantiationCode});
        return code.build();
    }

    protected AccessVisibility getAccessVisibility(RegisteredBean registeredBean, Member member) {
        AccessVisibility beanTypeAccessVisibility = AccessVisibility.forResolvableType((ResolvableType)registeredBean.getBeanType());
        AccessVisibility memberAccessVisibility = AccessVisibility.forMember((Member)member);
        return AccessVisibility.lowest((AccessVisibility[])new AccessVisibility[]{beanTypeAccessVisibility, memberAccessVisibility});
    }

    private CodeBlock generateParameterTypesCode(Class<?>[] parameterTypes, int offset) {
        CodeBlock.Builder builder = CodeBlock.builder();
        for (int i = offset; i < parameterTypes.length; ++i) {
            builder.add(i != offset ? ", " : "", new Object[0]);
            builder.add("$T.class", new Object[]{parameterTypes[i]});
        }
        return builder.build();
    }

    private GeneratedMethod generateGetInstanceMethod() {
        return this.methodGenerator.generateMethod(new Object[]{"get", "instance"});
    }

    private boolean isThrowingCheckedException(Executable executable) {
        return Arrays.stream(executable.getGenericExceptionTypes()).map(ResolvableType::forType).map(ResolvableType::toClass).anyMatch(Exception.class::isAssignableFrom);
    }
}

