/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;

public class AotFactoriesLoader {
    public static final String FACTORIES_RESOURCE_LOCATION = "META-INF/spring/aot.factories";
    private final ListableBeanFactory beanFactory;
    private final SpringFactoriesLoader factoriesLoader;

    public AotFactoriesLoader(ListableBeanFactory beanFactory) {
        ClassLoader classLoader;
        Assert.notNull((Object)beanFactory, (String)"'beanFactory' must not be null");
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)((Object)beanFactory);
            classLoader = configurableBeanFactory.getBeanClassLoader();
        } else {
            classLoader = null;
        }
        ClassLoader classLoader2 = classLoader;
        this.beanFactory = beanFactory;
        this.factoriesLoader = SpringFactoriesLoader.forResourceLocation((String)FACTORIES_RESOURCE_LOCATION, (ClassLoader)classLoader2);
    }

    public AotFactoriesLoader(ListableBeanFactory beanFactory, SpringFactoriesLoader factoriesLoader) {
        Assert.notNull((Object)beanFactory, (String)"'beanFactory' must not be null");
        Assert.notNull((Object)factoriesLoader, (String)"'factoriesLoader' must not be null");
        this.beanFactory = beanFactory;
        this.factoriesLoader = factoriesLoader;
    }

    public <T> List<T> load(Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(BeanFactoryUtils.beansOfTypeIncludingAncestors(this.beanFactory, type, true, false).values());
        result.addAll(this.factoriesLoader.load(type));
        AnnotationAwareOrderComparator.sort(result);
        return Collections.unmodifiableList(result);
    }
}

