/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Executable;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodGenerator;
import org.springframework.aot.generate.MethodNameGenerator;
import org.springframework.aot.generate.MethodReference;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGeneratorFactory;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeGenerator;
import org.springframework.beans.factory.aot.BeanRegistrationsCode;
import org.springframework.beans.factory.aot.ConstructorOrFactoryMethodResolver;
import org.springframework.beans.factory.aot.DefaultBeanRegistrationCodeFragments;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.javapoet.ClassName;
import org.springframework.lang.Nullable;

class BeanDefinitionMethodGenerator {
    private static final String FEATURE_NAME = "BeanDefinitions";
    private final BeanDefinitionMethodGeneratorFactory methodGeneratorFactory;
    private final RegisteredBean registeredBean;
    private final Executable constructorOrFactoryMethod;
    @Nullable
    private final String innerBeanPropertyName;
    private final List<BeanRegistrationAotContribution> aotContributions;

    BeanDefinitionMethodGenerator(BeanDefinitionMethodGeneratorFactory methodGeneratorFactory, RegisteredBean registeredBean, @Nullable String innerBeanPropertyName, List<BeanRegistrationAotContribution> aotContributions) {
        this.methodGeneratorFactory = methodGeneratorFactory;
        this.registeredBean = registeredBean;
        this.constructorOrFactoryMethod = ConstructorOrFactoryMethodResolver.resolve(registeredBean);
        this.innerBeanPropertyName = innerBeanPropertyName;
        this.aotContributions = aotContributions;
    }

    MethodReference generateBeanDefinitionMethod(GenerationContext generationContext, BeanRegistrationsCode beanRegistrationsCode) {
        BeanRegistrationCodeFragments codeFragments = this.getCodeFragments(generationContext, beanRegistrationsCode);
        Class<?> target = codeFragments.getTarget(this.registeredBean, this.constructorOrFactoryMethod);
        if (!target.getName().startsWith("java.")) {
            GeneratedClass generatedClass = generationContext.getGeneratedClasses().forFeatureComponent(FEATURE_NAME, target).getOrGenerate(FEATURE_NAME, type -> {
                type.addJavadoc("Bean definitions for {@link $T}", new Object[]{target});
                type.addModifiers(new Modifier[]{Modifier.PUBLIC});
            });
            MethodGenerator methodGenerator = generatedClass.getMethodGenerator().withName(new Object[]{this.getName()});
            GeneratedMethod generatedMethod = this.generateBeanDefinitionMethod(generationContext, generatedClass.getName(), methodGenerator, codeFragments, Modifier.PUBLIC);
            return MethodReference.ofStatic((ClassName)generatedClass.getName(), (String)generatedMethod.getName());
        }
        MethodGenerator methodGenerator = beanRegistrationsCode.getMethodGenerator().withName(new Object[]{this.getName()});
        GeneratedMethod generatedMethod = this.generateBeanDefinitionMethod(generationContext, beanRegistrationsCode.getClassName(), methodGenerator, codeFragments, Modifier.PRIVATE);
        return MethodReference.ofStatic((ClassName)beanRegistrationsCode.getClassName(), (String)generatedMethod.getName());
    }

    private BeanRegistrationCodeFragments getCodeFragments(GenerationContext generationContext, BeanRegistrationsCode beanRegistrationsCode) {
        BeanRegistrationCodeFragments codeFragments = new DefaultBeanRegistrationCodeFragments(beanRegistrationsCode, this.registeredBean, this.methodGeneratorFactory);
        for (BeanRegistrationAotContribution aotContribution : this.aotContributions) {
            codeFragments = aotContribution.customizeBeanRegistrationCodeFragments(generationContext, codeFragments);
        }
        return codeFragments;
    }

    private GeneratedMethod generateBeanDefinitionMethod(GenerationContext generationContext, ClassName className, MethodGenerator methodGenerator, BeanRegistrationCodeFragments codeFragments, Modifier modifier) {
        BeanRegistrationCodeGenerator codeGenerator = new BeanRegistrationCodeGenerator(className, methodGenerator, this.registeredBean, this.constructorOrFactoryMethod, codeFragments);
        GeneratedMethod method = methodGenerator.generateMethod(new Object[]{"get", "bean", "definition"});
        this.aotContributions.forEach(aotContribution -> aotContribution.applyTo(generationContext, codeGenerator));
        return method.using(builder -> {
            builder.addJavadoc("Get the $L definition for '$L'", new Object[]{!this.registeredBean.isInnerBean() ? "bean" : "inner-bean", this.getName()});
            builder.addModifiers(new Modifier[]{modifier, Modifier.STATIC});
            builder.returns(BeanDefinition.class);
            builder.addCode(codeGenerator.generateCode(generationContext));
        });
    }

    private String getName() {
        RegisteredBean nonGeneratedParent;
        if (this.innerBeanPropertyName != null) {
            return this.innerBeanPropertyName;
        }
        if (!this.registeredBean.isGeneratedBeanName()) {
            return this.getSimpleBeanName(this.registeredBean.getBeanName());
        }
        for (nonGeneratedParent = this.registeredBean; nonGeneratedParent != null && nonGeneratedParent.isGeneratedBeanName(); nonGeneratedParent = nonGeneratedParent.getParent()) {
        }
        return nonGeneratedParent != null ? MethodNameGenerator.join((Object[])new Object[]{this.getSimpleBeanName(nonGeneratedParent.getBeanName()), "innerBean"}) : "innerBean";
    }

    private String getSimpleBeanName(String beanName) {
        int lastDot = beanName.lastIndexOf(46);
        beanName = lastDot != -1 ? beanName.substring(lastDot + 1) : beanName;
        int lastDollar = beanName.lastIndexOf(36);
        beanName = lastDollar != -1 ? beanName.substring(lastDollar + 1) : beanName;
        return beanName;
    }
}

