/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class ConstructorOrFactoryMethodResolver {
    private final ConfigurableBeanFactory beanFactory;
    @Nullable
    private final ClassLoader classLoader;

    ConstructorOrFactoryMethodResolver(ConfigurableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.classLoader = beanFactory.getBeanClassLoader() != null ? beanFactory.getBeanClassLoader() : ClassUtils.getDefaultClassLoader();
    }

    @Nullable
    Executable resolve(BeanDefinition beanDefinition) {
        Supplier<ResolvableType> beanType = () -> this.getBeanType(beanDefinition);
        List<ResolvableType> valueTypes = beanDefinition.hasConstructorArgumentValues() ? this.determineParameterValueTypes(beanDefinition.getConstructorArgumentValues()) : Collections.emptyList();
        Method resolvedFactoryMethod = this.resolveFactoryMethod(beanDefinition, valueTypes);
        if (resolvedFactoryMethod != null) {
            return resolvedFactoryMethod;
        }
        Class<?> factoryBeanClass = this.getFactoryBeanClass(beanDefinition);
        if (factoryBeanClass != null && !factoryBeanClass.equals(beanDefinition.getResolvableType().toClass())) {
            ResolvableType resolvableType = beanDefinition.getResolvableType();
            boolean isCompatible = ResolvableType.forClass(factoryBeanClass).as(FactoryBean.class).getGeneric(new int[]{0}).isAssignableFrom(resolvableType);
            Assert.state((boolean)isCompatible, () -> String.format("Incompatible target type '%s' for factory bean '%s'", resolvableType.toClass().getName(), factoryBeanClass.getName()));
            return this.resolveConstructor(() -> ResolvableType.forClass((Class)factoryBeanClass), valueTypes);
        }
        Executable resolvedConstructor = this.resolveConstructor(beanType, valueTypes);
        if (resolvedConstructor != null) {
            return resolvedConstructor;
        }
        Field field = ReflectionUtils.findField(RootBeanDefinition.class, (String)"resolvedConstructorOrFactoryMethod");
        if (field != null) {
            ReflectionUtils.makeAccessible((Field)field);
            return (Executable)ReflectionUtils.getField((Field)field, (Object)beanDefinition);
        }
        return null;
    }

    private List<ResolvableType> determineParameterValueTypes(ConstructorArgumentValues constructorArgumentValues) {
        ArrayList<ResolvableType> parameterTypes = new ArrayList<ResolvableType>();
        for (ConstructorArgumentValues.ValueHolder valueHolder : constructorArgumentValues.getIndexedArgumentValues().values()) {
            parameterTypes.add(this.determineParameterValueType(valueHolder));
        }
        return parameterTypes;
    }

    private ResolvableType determineParameterValueType(ConstructorArgumentValues.ValueHolder valueHolder) {
        if (valueHolder.getType() != null) {
            return ResolvableType.forClass(this.loadClass(valueHolder.getType()));
        }
        Object value = valueHolder.getValue();
        if (value instanceof BeanReference) {
            RuntimeBeanReference rbr;
            BeanReference br = (BeanReference)value;
            if (value instanceof RuntimeBeanReference && (rbr = (RuntimeBeanReference)value).getBeanType() != null) {
                return ResolvableType.forClass(rbr.getBeanType());
            }
            return ResolvableType.forClass(this.beanFactory.getType(br.getBeanName(), false));
        }
        if (value instanceof BeanDefinition) {
            BeanDefinition bd = (BeanDefinition)value;
            return this.extractTypeFromBeanDefinition(this.getBeanType(bd));
        }
        if (value instanceof Class) {
            Class clazz = (Class)value;
            return ResolvableType.forClassWithGenerics(Class.class, (Class[])new Class[]{clazz});
        }
        return ResolvableType.forInstance((Object)value);
    }

    private ResolvableType extractTypeFromBeanDefinition(ResolvableType type) {
        if (FactoryBean.class.isAssignableFrom(type.toClass())) {
            return type.as(FactoryBean.class).getGeneric(new int[]{0});
        }
        return type;
    }

    @Nullable
    private Method resolveFactoryMethod(BeanDefinition beanDefinition, List<ResolvableType> valueTypes) {
        RootBeanDefinition rbd;
        Method resolvedFactoryMethod;
        if (beanDefinition instanceof RootBeanDefinition && (resolvedFactoryMethod = (rbd = (RootBeanDefinition)beanDefinition).getResolvedFactoryMethod()) != null) {
            return resolvedFactoryMethod;
        }
        String factoryMethodName = beanDefinition.getFactoryMethodName();
        if (factoryMethodName != null) {
            String factoryBeanName = beanDefinition.getFactoryBeanName();
            Class<?> beanClass = this.getBeanClass(factoryBeanName != null ? this.beanFactory.getMergedBeanDefinition(factoryBeanName) : beanDefinition);
            ArrayList<Method> methods = new ArrayList<Method>();
            Assert.state((beanClass != null ? 1 : 0) != 0, () -> "Failed to determine bean class of " + beanDefinition);
            ReflectionUtils.doWithMethods(beanClass, methods::add, method -> this.isFactoryMethodCandidate(beanClass, method, factoryMethodName));
            if (methods.size() >= 1) {
                Function<Method, List<ResolvableType>> parameterTypesFactory = method -> {
                    ArrayList<ResolvableType> types = new ArrayList<ResolvableType>();
                    for (int i = 0; i < method.getParameterCount(); ++i) {
                        types.add(ResolvableType.forMethodParameter((Method)method, (int)i));
                    }
                    return types;
                };
                return (Method)this.resolveFactoryMethod(methods, parameterTypesFactory, valueTypes);
            }
        }
        return null;
    }

    private boolean isFactoryMethodCandidate(Class<?> beanClass, Method method, String factoryMethodName) {
        if (method.getName().equals(factoryMethodName)) {
            if (Modifier.isStatic(method.getModifiers())) {
                return method.getDeclaringClass().equals(beanClass);
            }
            return !Modifier.isPrivate(method.getModifiers());
        }
        return false;
    }

    @Nullable
    private Executable resolveConstructor(Supplier<ResolvableType> beanType, List<ResolvableType> valueTypes) {
        Class type = ClassUtils.getUserClass((Class)beanType.get().toClass());
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        if (constructors.length == 1) {
            return constructors[0];
        }
        for (Constructor<?> constructor : constructors) {
            if (!MergedAnnotations.from(constructor).isPresent(Autowired.class)) continue;
            return constructor;
        }
        Function<Constructor, List> parameterTypesFactory = executable -> {
            ArrayList<ResolvableType> types = new ArrayList<ResolvableType>();
            for (int i = 0; i < executable.getParameterCount(); ++i) {
                types.add(ResolvableType.forConstructorParameter((Constructor)executable, (int)i));
            }
            return types;
        };
        List<Constructor> matches = Arrays.stream(constructors).filter(executable -> this.match((List)parameterTypesFactory.apply((Constructor)executable), valueTypes, FallbackMode.NONE)).toList();
        if (matches.size() == 1) {
            return matches.get(0);
        }
        List<Constructor> assignableElementFallbackMatches = Arrays.stream(constructors).filter(executable -> this.match((List)parameterTypesFactory.apply((Constructor)executable), valueTypes, FallbackMode.ASSIGNABLE_ELEMENT)).toList();
        if (assignableElementFallbackMatches.size() == 1) {
            return assignableElementFallbackMatches.get(0);
        }
        List<Constructor> typeConversionFallbackMatches = Arrays.stream(constructors).filter(executable -> this.match((List)parameterTypesFactory.apply((Constructor)executable), valueTypes, FallbackMode.TYPE_CONVERSION)).toList();
        return typeConversionFallbackMatches.size() == 1 ? (Executable)typeConversionFallbackMatches.get(0) : null;
    }

    @Nullable
    private Executable resolveFactoryMethod(List<Method> executables, Function<Method, List<ResolvableType>> parameterTypesFactory, List<ResolvableType> valueTypes) {
        List<Method> matches = executables.stream().filter(executable -> this.match((List)parameterTypesFactory.apply((Method)executable), valueTypes, FallbackMode.NONE)).toList();
        if (matches.size() == 1) {
            return matches.get(0);
        }
        List<Method> assignableElementFallbackMatches = executables.stream().filter(executable -> this.match((List)parameterTypesFactory.apply((Method)executable), valueTypes, FallbackMode.ASSIGNABLE_ELEMENT)).toList();
        if (assignableElementFallbackMatches.size() == 1) {
            return assignableElementFallbackMatches.get(0);
        }
        List<Method> typeConversionFallbackMatches = executables.stream().filter(executable -> this.match((List)parameterTypesFactory.apply((Method)executable), valueTypes, FallbackMode.TYPE_CONVERSION)).toList();
        Assert.state((typeConversionFallbackMatches.size() <= 1 ? 1 : 0) != 0, () -> "Multiple matches with parameters '" + valueTypes + "': " + typeConversionFallbackMatches);
        return typeConversionFallbackMatches.size() == 1 ? (Executable)typeConversionFallbackMatches.get(0) : null;
    }

    private boolean match(List<ResolvableType> parameterTypes, List<ResolvableType> valueTypes, FallbackMode fallbackMode) {
        if (parameterTypes.size() != valueTypes.size()) {
            return false;
        }
        for (int i = 0; i < parameterTypes.size(); ++i) {
            if (this.isMatch(parameterTypes.get(i), valueTypes.get(i), fallbackMode)) continue;
            return false;
        }
        return true;
    }

    private boolean isMatch(ResolvableType parameterType, ResolvableType valueType, FallbackMode fallbackMode) {
        if (this.isAssignable(valueType).test(parameterType)) {
            return true;
        }
        return switch (fallbackMode) {
            case FallbackMode.ASSIGNABLE_ELEMENT -> this.isAssignable(valueType).test(this.extractElementType(parameterType));
            case FallbackMode.TYPE_CONVERSION -> this.typeConversionFallback(valueType).test(parameterType);
            default -> false;
        };
    }

    private Predicate<ResolvableType> isAssignable(ResolvableType valueType) {
        return parameterType -> parameterType.isAssignableFrom(valueType);
    }

    private ResolvableType extractElementType(ResolvableType parameterType) {
        if (parameterType.isArray()) {
            return parameterType.getComponentType();
        }
        if (Collection.class.isAssignableFrom(parameterType.toClass())) {
            return parameterType.as(Collection.class).getGeneric(new int[]{0});
        }
        return ResolvableType.NONE;
    }

    private Predicate<ResolvableType> typeConversionFallback(ResolvableType valueType) {
        return parameterType -> {
            if (this.valueOrCollection(valueType, this::isStringForClassFallback).test((ResolvableType)parameterType)) {
                return true;
            }
            return this.valueOrCollection(valueType, this::isSimpleValueType).test((ResolvableType)parameterType);
        };
    }

    private Predicate<ResolvableType> valueOrCollection(ResolvableType valueType, Function<ResolvableType, Predicate<ResolvableType>> predicateProvider) {
        return parameterType -> {
            if (((Predicate)predicateProvider.apply(valueType)).test(parameterType)) {
                return true;
            }
            if (((Predicate)predicateProvider.apply(this.extractElementType(valueType))).test(this.extractElementType((ResolvableType)parameterType))) {
                return true;
            }
            return ((Predicate)predicateProvider.apply(valueType)).test(this.extractElementType((ResolvableType)parameterType));
        };
    }

    private Predicate<ResolvableType> isStringForClassFallback(ResolvableType valueType) {
        return parameterType -> valueType.isAssignableFrom(String.class) && parameterType.isAssignableFrom(Class.class);
    }

    private Predicate<ResolvableType> isSimpleValueType(ResolvableType valueType) {
        return parameterType -> BeanUtils.isSimpleValueType(parameterType.toClass()) && BeanUtils.isSimpleValueType(valueType.toClass());
    }

    @Nullable
    private Class<?> getFactoryBeanClass(BeanDefinition beanDefinition) {
        RootBeanDefinition rbd;
        if (beanDefinition instanceof RootBeanDefinition && (rbd = (RootBeanDefinition)beanDefinition).hasBeanClass()) {
            Class<?> beanClass = rbd.getBeanClass();
            return FactoryBean.class.isAssignableFrom(beanClass) ? beanClass : null;
        }
        return null;
    }

    @Nullable
    private Class<?> getBeanClass(BeanDefinition beanDefinition) {
        AbstractBeanDefinition abd;
        if (beanDefinition instanceof AbstractBeanDefinition && (abd = (AbstractBeanDefinition)beanDefinition).hasBeanClass()) {
            return abd.getBeanClass();
        }
        return beanDefinition.getBeanClassName() != null ? this.loadClass(beanDefinition.getBeanClassName()) : null;
    }

    private ResolvableType getBeanType(BeanDefinition beanDefinition) {
        RootBeanDefinition rbd;
        ResolvableType resolvableType = beanDefinition.getResolvableType();
        if (resolvableType != ResolvableType.NONE) {
            return resolvableType;
        }
        if (beanDefinition instanceof RootBeanDefinition && (rbd = (RootBeanDefinition)beanDefinition).hasBeanClass()) {
            return ResolvableType.forClass(rbd.getBeanClass());
        }
        String beanClassName = beanDefinition.getBeanClassName();
        if (beanClassName != null) {
            return ResolvableType.forClass(this.loadClass(beanClassName));
        }
        throw new IllegalStateException("Failed to determine bean class of " + beanDefinition);
    }

    private Class<?> loadClass(String beanClassName) {
        try {
            return ClassUtils.forName((String)beanClassName, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Failed to load class " + beanClassName);
        }
    }

    @Nullable
    static Executable resolve(RegisteredBean registeredBean) {
        return new ConstructorOrFactoryMethodResolver(registeredBean.getBeanFactory()).resolve(registeredBean.getMergedBeanDefinition());
    }

    static enum FallbackMode {
        NONE,
        ASSIGNABLE_ELEMENT,
        TYPE_CONVERSION;

    }
}

