/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.aot.AotServices;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGenerator;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationExcludeFilter;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.log.LogMessage;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class BeanDefinitionMethodGeneratorFactory {
    private static final Log logger = LogFactory.getLog(BeanDefinitionMethodGeneratorFactory.class);
    private final AotServices<BeanRegistrationAotProcessor> aotProcessors;
    private final AotServices<BeanRegistrationExcludeFilter> excludeFilters;

    BeanDefinitionMethodGeneratorFactory(ConfigurableListableBeanFactory beanFactory) {
        this(AotServices.factoriesAndBeans(beanFactory));
    }

    BeanDefinitionMethodGeneratorFactory(AotServices.Loader loader) {
        this.aotProcessors = loader.load(BeanRegistrationAotProcessor.class);
        this.excludeFilters = loader.load(BeanRegistrationExcludeFilter.class);
        for (BeanRegistrationExcludeFilter excludeFilter : this.excludeFilters) {
            if (this.excludeFilters.getSource(excludeFilter) != AotServices.Source.BEAN_FACTORY) continue;
            Assert.state((excludeFilter instanceof BeanRegistrationAotProcessor || excludeFilter instanceof BeanFactoryInitializationAotProcessor ? 1 : 0) != 0, () -> "BeanRegistrationExcludeFilter bean of type %s must also implement an AOT processor interface".formatted(excludeFilter.getClass().getName()));
        }
    }

    @Nullable
    BeanDefinitionMethodGenerator getBeanDefinitionMethodGenerator(RegisteredBean registeredBean, @Nullable String innerBeanPropertyName) {
        if (this.isExcluded(registeredBean)) {
            return null;
        }
        List<BeanRegistrationAotContribution> contributions = this.getAotContributions(registeredBean);
        return new BeanDefinitionMethodGenerator(this, registeredBean, innerBeanPropertyName, contributions);
    }

    private boolean isExcluded(RegisteredBean registeredBean) {
        if (this.isImplicitlyExcluded(registeredBean)) {
            return true;
        }
        for (BeanRegistrationExcludeFilter excludeFilter : this.excludeFilters) {
            if (!excludeFilter.isExcludedFromAotProcessing(registeredBean)) continue;
            logger.trace((Object)LogMessage.format((String)"Excluding registered bean '%s' from bean factory %s due to %s", (Object)registeredBean.getBeanName(), (Object)ObjectUtils.identityToString((Object)registeredBean.getBeanFactory()), (Object)excludeFilter.getClass().getName()));
            return true;
        }
        return false;
    }

    private boolean isImplicitlyExcluded(RegisteredBean registeredBean) {
        Class<?> beanClass = registeredBean.getBeanClass();
        if (BeanFactoryInitializationAotProcessor.class.isAssignableFrom(beanClass)) {
            return true;
        }
        if (BeanRegistrationAotProcessor.class.isAssignableFrom(beanClass)) {
            BeanRegistrationAotProcessor processor = this.aotProcessors.findByBeanName(registeredBean.getBeanName());
            return processor == null || processor.isBeanExcludedFromAotProcessing();
        }
        return false;
    }

    private List<BeanRegistrationAotContribution> getAotContributions(RegisteredBean registeredBean) {
        String beanName = registeredBean.getBeanName();
        ArrayList<BeanRegistrationAotContribution> contributions = new ArrayList<BeanRegistrationAotContribution>();
        for (BeanRegistrationAotProcessor aotProcessor : this.aotProcessors) {
            BeanRegistrationAotContribution contribution = aotProcessor.processAheadOfTime(registeredBean);
            if (contribution == null) continue;
            logger.trace((Object)LogMessage.format((String)"Adding bean registration AOT contribution %S from %S to '%S'", (Object)contribution.getClass().getName(), (Object)aotProcessor.getClass().getName(), (Object)beanName));
            contributions.add(contribution);
        }
        return contributions;
    }
}

