/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.ExtendedBeanInfoFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.aot.BeanDefinitionPropertyValueCodeGenerator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.javapoet.CodeBlock;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class BeanDefinitionPropertiesCodeGenerator {
    private static final RootBeanDefinition DEFAULT_BEAN_DEFINITION = new RootBeanDefinition();
    private static final String BEAN_DEFINITION_VARIABLE = "beanDefinition";
    private static final BeanInfoFactory beanInfoFactory = new ExtendedBeanInfoFactory();
    private final RuntimeHints hints;
    private final Predicate<String> attributeFilter;
    private final BiFunction<String, Object, CodeBlock> customValueCodeGenerator;
    private final BeanDefinitionPropertyValueCodeGenerator valueCodeGenerator;

    BeanDefinitionPropertiesCodeGenerator(RuntimeHints hints, Predicate<String> attributeFilter, GeneratedMethods generatedMethods, BiFunction<String, Object, CodeBlock> customValueCodeGenerator) {
        this.hints = hints;
        this.attributeFilter = attributeFilter;
        this.customValueCodeGenerator = customValueCodeGenerator;
        this.valueCodeGenerator = new BeanDefinitionPropertyValueCodeGenerator(generatedMethods);
    }

    CodeBlock generateCode(RootBeanDefinition beanDefinition) {
        CodeBlock.Builder code = CodeBlock.builder();
        this.addStatementForValue(code, beanDefinition, BeanDefinition::isPrimary, "$L.setPrimary($L)");
        this.addStatementForValue(code, beanDefinition, BeanDefinition::getScope, this::hasScope, "$L.setScope($S)");
        this.addStatementForValue(code, beanDefinition, BeanDefinition::getDependsOn, this::hasDependsOn, "$L.setDependsOn($L)", this::toStringVarArgs);
        this.addStatementForValue(code, beanDefinition, BeanDefinition::isAutowireCandidate, "$L.setAutowireCandidate($L)");
        this.addStatementForValue(code, beanDefinition, BeanDefinition::getRole, this::hasRole, "$L.setRole($L)", this::toRole);
        this.addStatementForValue(code, beanDefinition, AbstractBeanDefinition::getLazyInit, "$L.setLazyInit($L)");
        this.addStatementForValue(code, beanDefinition, AbstractBeanDefinition::isSynthetic, "$L.setSynthetic($L)");
        this.addInitDestroyMethods(code, beanDefinition, beanDefinition.getInitMethodNames(), "$L.setInitMethodNames($L)");
        this.addInitDestroyMethods(code, beanDefinition, beanDefinition.getDestroyMethodNames(), "$L.setDestroyMethodNames($L)");
        this.addConstructorArgumentValues(code, beanDefinition);
        this.addPropertyValues(code, beanDefinition);
        this.addAttributes(code, beanDefinition);
        return code.build();
    }

    private void addInitDestroyMethods(CodeBlock.Builder code, AbstractBeanDefinition beanDefinition, @Nullable String[] methodNames, String format) {
        if (!ObjectUtils.isEmpty((Object[])methodNames)) {
            Class beanType = ClassUtils.getUserClass((Class)beanDefinition.getResolvableType().toClass());
            Arrays.stream(methodNames).forEach(methodName -> this.addInitDestroyHint(beanType, (String)methodName));
            CodeBlock arguments = (CodeBlock)Arrays.stream(methodNames).map(name -> CodeBlock.of((String)"$S", (Object[])new Object[]{name})).collect(CodeBlock.joining((String)", "));
            code.addStatement(format, new Object[]{BEAN_DEFINITION_VARIABLE, arguments});
        }
    }

    private void addInitDestroyHint(Class<?> beanUserClass, String methodName) {
        Method method = ReflectionUtils.findMethod(beanUserClass, (String)methodName);
        if (method != null) {
            this.hints.reflection().registerMethod(method, ExecutableMode.INVOKE);
        }
    }

    private void addConstructorArgumentValues(CodeBlock.Builder code, BeanDefinition beanDefinition) {
        Map<Integer, ConstructorArgumentValues.ValueHolder> argumentValues = beanDefinition.getConstructorArgumentValues().getIndexedArgumentValues();
        if (!argumentValues.isEmpty()) {
            argumentValues.forEach((index, valueHolder) -> {
                Object value;
                String name = valueHolder.getName();
                CodeBlock valueCode = this.customValueCodeGenerator.apply(name, value = valueHolder.getValue());
                if (valueCode == null) {
                    valueCode = this.valueCodeGenerator.generateCode(value);
                }
                code.addStatement("$L.getConstructorArgumentValues().addIndexedArgumentValue($L, $L)", new Object[]{BEAN_DEFINITION_VARIABLE, index, valueCode});
            });
        }
    }

    private void addPropertyValues(CodeBlock.Builder code, RootBeanDefinition beanDefinition) {
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        if (!propertyValues.isEmpty()) {
            BeanInfo beanInfo;
            for (PropertyValue propertyValue : propertyValues) {
                Object value;
                String name = propertyValue.getName();
                CodeBlock valueCode = this.customValueCodeGenerator.apply(name, value = propertyValue.getValue());
                if (valueCode == null) {
                    valueCode = this.valueCodeGenerator.generateCode(value);
                }
                code.addStatement("$L.getPropertyValues().addPropertyValue($S, $L)", new Object[]{BEAN_DEFINITION_VARIABLE, propertyValue.getName(), valueCode});
            }
            Class<?> infrastructureType = this.getInfrastructureType(beanDefinition);
            BeanInfo beanInfo2 = beanInfo = infrastructureType != Object.class ? this.getBeanInfo(infrastructureType) : null;
            if (beanInfo != null) {
                Map<String, Method> writeMethods = this.getWriteMethods(beanInfo);
                for (PropertyValue propertyValue : propertyValues) {
                    Method writeMethod = writeMethods.get(propertyValue.getName());
                    if (writeMethod == null) continue;
                    this.hints.reflection().registerMethod(writeMethod, ExecutableMode.INVOKE);
                }
            }
        }
    }

    private Class<?> getInfrastructureType(RootBeanDefinition beanDefinition) {
        Class<?> beanClass;
        if (beanDefinition.hasBeanClass() && FactoryBean.class.isAssignableFrom(beanClass = beanDefinition.getBeanClass())) {
            return beanClass;
        }
        return ClassUtils.getUserClass((Class)beanDefinition.getResolvableType().toClass());
    }

    @Nullable
    private BeanInfo getBeanInfo(Class<?> beanType) {
        try {
            BeanInfo beanInfo = beanInfoFactory.getBeanInfo(beanType);
            if (beanInfo != null) {
                return beanInfo;
            }
            return Introspector.getBeanInfo(beanType, 3);
        }
        catch (IntrospectionException ex) {
            return null;
        }
    }

    private Map<String, Method> getWriteMethods(BeanInfo beanInfo) {
        HashMap<String, Method> writeMethods = new HashMap<String, Method>();
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            writeMethods.put(propertyDescriptor.getName(), propertyDescriptor.getWriteMethod());
        }
        return Collections.unmodifiableMap(writeMethods);
    }

    private void addAttributes(CodeBlock.Builder code, BeanDefinition beanDefinition) {
        Object[] attributeNames = beanDefinition.attributeNames();
        if (!ObjectUtils.isEmpty((Object[])attributeNames)) {
            for (Object attributeName : attributeNames) {
                if (!this.attributeFilter.test((String)attributeName)) continue;
                CodeBlock value = this.valueCodeGenerator.generateCode(beanDefinition.getAttribute((String)attributeName));
                code.addStatement("$L.setAttribute($S, $L)", new Object[]{BEAN_DEFINITION_VARIABLE, attributeName, value});
            }
        }
    }

    private boolean hasScope(String defaultValue, String actualValue) {
        return StringUtils.hasText((String)actualValue) && !"singleton".equals(actualValue);
    }

    private boolean hasDependsOn(String[] defaultValue, String[] actualValue) {
        return !ObjectUtils.isEmpty((Object[])actualValue);
    }

    private boolean hasRole(int defaultValue, int actualValue) {
        return actualValue != 0;
    }

    private CodeBlock toStringVarArgs(String[] strings) {
        return (CodeBlock)Arrays.stream(strings).map(string -> CodeBlock.of((String)"$S", (Object[])new Object[]{string})).collect(CodeBlock.joining((String)","));
    }

    private Object toRole(int value) {
        return switch (value) {
            case 2 -> CodeBlock.builder().add("$T.ROLE_INFRASTRUCTURE", new Object[]{BeanDefinition.class}).build();
            case 1 -> CodeBlock.builder().add("$T.ROLE_SUPPORT", new Object[]{BeanDefinition.class}).build();
            default -> value;
        };
    }

    private <B extends BeanDefinition, T> void addStatementForValue(CodeBlock.Builder code, BeanDefinition beanDefinition, Function<B, T> getter, String format) {
        this.addStatementForValue(code, beanDefinition, getter, (defaultValue, actualValue) -> !Objects.equals(defaultValue, actualValue), format);
    }

    private <B extends BeanDefinition, T> void addStatementForValue(CodeBlock.Builder code, BeanDefinition beanDefinition, Function<B, T> getter, BiPredicate<T, T> filter, String format) {
        this.addStatementForValue(code, beanDefinition, getter, filter, format, actualValue -> actualValue);
    }

    private <B extends BeanDefinition, T> void addStatementForValue(CodeBlock.Builder code, BeanDefinition beanDefinition, Function<B, T> getter, BiPredicate<T, T> filter, String format, Function<T, Object> formatter) {
        T actualValue;
        T defaultValue = getter.apply(DEFAULT_BEAN_DEFINITION);
        if (filter.test(defaultValue, actualValue = getter.apply(beanDefinition))) {
            code.addStatement(format, new Object[]{BEAN_DEFINITION_VARIABLE, formatter.apply(actualValue)});
        }
    }
}

