/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.util.Map;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGenerator;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.aot.BeanRegistrationsCode;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;

class BeanRegistrationsAotContribution
implements BeanFactoryInitializationAotContribution {
    private static final String BEAN_FACTORY_PARAMETER_NAME = "beanFactory";
    private final Map<String, BeanDefinitionMethodGenerator> registrations;

    BeanRegistrationsAotContribution(Map<String, BeanDefinitionMethodGenerator> registrations) {
        this.registrations = registrations;
    }

    @Override
    public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
        GeneratedClass generatedClass = generationContext.getGeneratedClasses().addForFeature("BeanFactoryRegistrations", type -> {
            type.addJavadoc("Register bean definitions for the bean factory.", new Object[0]);
            type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        });
        BeanRegistrationsCodeGenerator codeGenerator = new BeanRegistrationsCodeGenerator(generatedClass);
        GeneratedMethod generatedMethod = codeGenerator.getMethods().add("registerBeanDefinitions", method -> this.generateRegisterMethod((MethodSpec.Builder)method, generationContext, codeGenerator));
        beanFactoryInitializationCode.addInitializer(generatedMethod.toMethodReference());
    }

    private void generateRegisterMethod(MethodSpec.Builder method, GenerationContext generationContext, BeanRegistrationsCode beanRegistrationsCode) {
        method.addJavadoc("Register the bean definitions.", new Object[0]);
        method.addModifiers(new Modifier[]{Modifier.PUBLIC});
        method.addParameter(DefaultListableBeanFactory.class, BEAN_FACTORY_PARAMETER_NAME, new Modifier[0]);
        CodeBlock.Builder code = CodeBlock.builder();
        this.registrations.forEach((beanName, beanDefinitionMethodGenerator) -> {
            MethodReference beanDefinitionMethod = beanDefinitionMethodGenerator.generateBeanDefinitionMethod(generationContext, beanRegistrationsCode);
            CodeBlock methodInvocation = beanDefinitionMethod.toInvokeCodeBlock(MethodReference.ArgumentCodeGenerator.none(), beanRegistrationsCode.getClassName());
            code.addStatement("$L.registerBeanDefinition($S, $L)", new Object[]{BEAN_FACTORY_PARAMETER_NAME, beanName, methodInvocation});
        });
        method.addCode(code.build());
    }

    static class BeanRegistrationsCodeGenerator
    implements BeanRegistrationsCode {
        private final GeneratedClass generatedClass;

        public BeanRegistrationsCodeGenerator(GeneratedClass generatedClass) {
            this.generatedClass = generatedClass;
        }

        @Override
        public ClassName getClassName() {
            return this.generatedClass.getName();
        }

        @Override
        public GeneratedMethods getMethods() {
            return this.generatedClass.getMethods();
        }
    }
}

