/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Consumer;
import org.springframework.aot.generate.AccessVisibility;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.beans.factory.aot.AutowiredArgumentsCodeGenerator;
import org.springframework.beans.factory.aot.BeanInstanceSupplier;
import org.springframework.beans.factory.support.InstanceSupplier;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.javapoet.TypeName;
import org.springframework.util.ClassUtils;
import org.springframework.util.function.ThrowingSupplier;

class InstanceSupplierCodeGenerator {
    private static final String REGISTERED_BEAN_PARAMETER_NAME = "registeredBean";
    private static final String ARGS_PARAMETER_NAME = "args";
    private static final javax.lang.model.element.Modifier[] PRIVATE_STATIC = new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PRIVATE, javax.lang.model.element.Modifier.STATIC};
    private static final CodeBlock NO_ARGS = CodeBlock.of((String)"", (Object[])new Object[0]);
    private final GenerationContext generationContext;
    private final ClassName className;
    private final GeneratedMethods generatedMethods;
    private final boolean allowDirectSupplierShortcut;

    InstanceSupplierCodeGenerator(GenerationContext generationContext, ClassName className, GeneratedMethods generatedMethods, boolean allowDirectSupplierShortcut) {
        this.generationContext = generationContext;
        this.className = className;
        this.generatedMethods = generatedMethods;
        this.allowDirectSupplierShortcut = allowDirectSupplierShortcut;
    }

    CodeBlock generateCode(RegisteredBean registeredBean, Executable constructorOrFactoryMethod) {
        if (constructorOrFactoryMethod instanceof Constructor) {
            Constructor constructor = (Constructor)constructorOrFactoryMethod;
            return this.generateCodeForConstructor(registeredBean, constructor);
        }
        if (constructorOrFactoryMethod instanceof Method) {
            Method method = (Method)constructorOrFactoryMethod;
            return this.generateCodeForFactoryMethod(registeredBean, method);
        }
        throw new IllegalStateException("No suitable executor found for " + registeredBean.getBeanName());
    }

    private CodeBlock generateCodeForConstructor(RegisteredBean registeredBean, Constructor<?> constructor) {
        String beanName = registeredBean.getBeanName();
        Class<?> beanClass = registeredBean.getBeanClass();
        Class declaringClass = ClassUtils.getUserClass(constructor.getDeclaringClass());
        boolean dependsOnBean = ClassUtils.isInnerClass((Class)declaringClass);
        AccessVisibility accessVisibility = this.getAccessVisibility(registeredBean, constructor);
        if (accessVisibility == AccessVisibility.PUBLIC || accessVisibility == AccessVisibility.PACKAGE_PRIVATE) {
            return this.generateCodeForAccessibleConstructor(beanName, beanClass, constructor, dependsOnBean, declaringClass);
        }
        return this.generateCodeForInaccessibleConstructor(beanName, beanClass, constructor, dependsOnBean);
    }

    private CodeBlock generateCodeForAccessibleConstructor(String beanName, Class<?> beanClass, Constructor<?> constructor, boolean dependsOnBean, Class<?> declaringClass) {
        this.generationContext.getRuntimeHints().reflection().registerConstructor(constructor, ExecutableMode.INTROSPECT);
        if (!dependsOnBean && constructor.getParameterCount() == 0) {
            if (!this.allowDirectSupplierShortcut) {
                return CodeBlock.of((String)"$T.using($T::new)", (Object[])new Object[]{InstanceSupplier.class, declaringClass});
            }
            if (!this.isThrowingCheckedException(constructor)) {
                return CodeBlock.of((String)"$T::new", (Object[])new Object[]{declaringClass});
            }
            return CodeBlock.of((String)"$T.of($T::new)", (Object[])new Object[]{ThrowingSupplier.class, declaringClass});
        }
        GeneratedMethod generatedMethod = this.generateGetInstanceSupplierMethod(method -> this.buildGetInstanceMethodForConstructor((MethodSpec.Builder)method, beanName, beanClass, constructor, declaringClass, dependsOnBean, PRIVATE_STATIC));
        return this.generateReturnStatement(generatedMethod);
    }

    private CodeBlock generateCodeForInaccessibleConstructor(String beanName, Class<?> beanClass, Constructor<?> constructor, boolean dependsOnBean) {
        this.generationContext.getRuntimeHints().reflection().registerConstructor(constructor, ExecutableMode.INVOKE);
        GeneratedMethod generatedMethod = this.generateGetInstanceSupplierMethod(method -> {
            method.addJavadoc("Get the bean instance supplier for '$L'.", new Object[]{beanName});
            method.addModifiers(PRIVATE_STATIC);
            method.returns((TypeName)ParameterizedTypeName.get(BeanInstanceSupplier.class, (Type[])new Type[]{beanClass}));
            int parameterOffset = !dependsOnBean ? 0 : 1;
            method.addStatement(this.generateResolverForConstructor(beanClass, constructor, parameterOffset));
        });
        return this.generateReturnStatement(generatedMethod);
    }

    private void buildGetInstanceMethodForConstructor(MethodSpec.Builder method, String beanName, Class<?> beanClass, Constructor<?> constructor, Class<?> declaringClass, boolean dependsOnBean, javax.lang.model.element.Modifier ... modifiers) {
        method.addJavadoc("Get the bean instance supplier for '$L'.", new Object[]{beanName});
        method.addModifiers(modifiers);
        method.returns((TypeName)ParameterizedTypeName.get(BeanInstanceSupplier.class, (Type[])new Type[]{beanClass}));
        int parameterOffset = !dependsOnBean ? 0 : 1;
        CodeBlock.Builder code = CodeBlock.builder();
        code.add(this.generateResolverForConstructor(beanClass, constructor, parameterOffset));
        boolean hasArguments = constructor.getParameterCount() > 0;
        CodeBlock arguments = hasArguments ? new AutowiredArgumentsCodeGenerator(declaringClass, constructor).generateCode(constructor.getParameterTypes(), parameterOffset) : NO_ARGS;
        CodeBlock newInstance = this.generateNewInstanceCodeForConstructor(dependsOnBean, declaringClass, arguments);
        code.add(this.generateWithGeneratorCode(hasArguments, newInstance));
        method.addStatement(code.build());
    }

    private CodeBlock generateResolverForConstructor(Class<?> beanClass, Constructor<?> constructor, int parameterOffset) {
        CodeBlock parameterTypes = this.generateParameterTypesCode(constructor.getParameterTypes(), parameterOffset);
        return CodeBlock.of((String)"return $T.<$T>forConstructor($L)", (Object[])new Object[]{BeanInstanceSupplier.class, beanClass, parameterTypes});
    }

    private CodeBlock generateNewInstanceCodeForConstructor(boolean dependsOnBean, Class<?> declaringClass, CodeBlock args) {
        if (!dependsOnBean) {
            return CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{declaringClass, args});
        }
        return CodeBlock.of((String)"$L.getBeanFactory().getBean($T.class).new $L($L)", (Object[])new Object[]{REGISTERED_BEAN_PARAMETER_NAME, declaringClass.getEnclosingClass(), declaringClass.getSimpleName(), args});
    }

    private CodeBlock generateCodeForFactoryMethod(RegisteredBean registeredBean, Method factoryMethod) {
        String beanName = registeredBean.getBeanName();
        Class<?> beanClass = registeredBean.getBeanClass();
        Class declaringClass = ClassUtils.getUserClass(factoryMethod.getDeclaringClass());
        boolean dependsOnBean = !Modifier.isStatic(factoryMethod.getModifiers());
        AccessVisibility accessVisibility = this.getAccessVisibility(registeredBean, factoryMethod);
        if (accessVisibility == AccessVisibility.PUBLIC || accessVisibility == AccessVisibility.PACKAGE_PRIVATE) {
            return this.generateCodeForAccessibleFactoryMethod(beanName, beanClass, factoryMethod, declaringClass, dependsOnBean);
        }
        return this.generateCodeForInaccessibleFactoryMethod(beanName, beanClass, factoryMethod, declaringClass);
    }

    private CodeBlock generateCodeForAccessibleFactoryMethod(String beanName, Class<?> beanClass, Method factoryMethod, Class<?> declaringClass, boolean dependsOnBean) {
        this.generationContext.getRuntimeHints().reflection().registerMethod(factoryMethod, ExecutableMode.INTROSPECT);
        if (!dependsOnBean && factoryMethod.getParameterCount() == 0) {
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T.<$T>forFactoryMethod($T.class, $S)", new Object[]{BeanInstanceSupplier.class, beanClass, declaringClass, factoryMethod.getName()});
            code.add(".withGenerator($T::$L)", new Object[]{declaringClass, factoryMethod.getName()});
            return code.build();
        }
        GeneratedMethod getInstanceMethod = this.generateGetInstanceSupplierMethod(method -> this.buildGetInstanceMethodForFactoryMethod((MethodSpec.Builder)method, beanName, beanClass, factoryMethod, declaringClass, dependsOnBean, PRIVATE_STATIC));
        return this.generateReturnStatement(getInstanceMethod);
    }

    private CodeBlock generateCodeForInaccessibleFactoryMethod(String beanName, Class<?> beanClass, Method factoryMethod, Class<?> declaringClass) {
        this.generationContext.getRuntimeHints().reflection().registerMethod(factoryMethod, ExecutableMode.INVOKE);
        GeneratedMethod getInstanceMethod = this.generateGetInstanceSupplierMethod(method -> {
            method.addJavadoc("Get the bean instance supplier for '$L'.", new Object[]{beanName});
            method.addModifiers(PRIVATE_STATIC);
            method.returns((TypeName)ParameterizedTypeName.get(BeanInstanceSupplier.class, (Type[])new Type[]{beanClass}));
            method.addStatement(this.generateInstanceSupplierForFactoryMethod(beanClass, factoryMethod, declaringClass, factoryMethod.getName()));
        });
        return this.generateReturnStatement(getInstanceMethod);
    }

    private void buildGetInstanceMethodForFactoryMethod(MethodSpec.Builder method, String beanName, Class<?> beanClass, Method factoryMethod, Class<?> declaringClass, boolean dependsOnBean, javax.lang.model.element.Modifier ... modifiers) {
        String factoryMethodName = factoryMethod.getName();
        method.addJavadoc("Get the bean instance supplier for '$L'.", new Object[]{beanName});
        method.addModifiers(modifiers);
        method.returns((TypeName)ParameterizedTypeName.get(BeanInstanceSupplier.class, (Type[])new Type[]{beanClass}));
        CodeBlock.Builder code = CodeBlock.builder();
        code.add(this.generateInstanceSupplierForFactoryMethod(beanClass, factoryMethod, declaringClass, factoryMethodName));
        boolean hasArguments = factoryMethod.getParameterCount() > 0;
        CodeBlock arguments = hasArguments ? new AutowiredArgumentsCodeGenerator(declaringClass, factoryMethod).generateCode(factoryMethod.getParameterTypes()) : NO_ARGS;
        CodeBlock newInstance = this.generateNewInstanceCodeForMethod(dependsOnBean, declaringClass, factoryMethodName, arguments);
        code.add(this.generateWithGeneratorCode(hasArguments, newInstance));
        method.addStatement(code.build());
    }

    private CodeBlock generateInstanceSupplierForFactoryMethod(Class<?> beanClass, Method factoryMethod, Class<?> declaringClass, String factoryMethodName) {
        if (factoryMethod.getParameterCount() == 0) {
            return CodeBlock.of((String)"return $T.<$T>forFactoryMethod($T.class, $S)", (Object[])new Object[]{BeanInstanceSupplier.class, beanClass, declaringClass, factoryMethodName});
        }
        CodeBlock parameterTypes = this.generateParameterTypesCode(factoryMethod.getParameterTypes(), 0);
        return CodeBlock.of((String)"return $T.<$T>forFactoryMethod($T.class, $S, $L)", (Object[])new Object[]{BeanInstanceSupplier.class, beanClass, declaringClass, factoryMethodName, parameterTypes});
    }

    private CodeBlock generateNewInstanceCodeForMethod(boolean dependsOnBean, Class<?> declaringClass, String factoryMethodName, CodeBlock args) {
        if (!dependsOnBean) {
            return CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{declaringClass, factoryMethodName, args});
        }
        return CodeBlock.of((String)"$L.getBeanFactory().getBean($T.class).$L($L)", (Object[])new Object[]{REGISTERED_BEAN_PARAMETER_NAME, declaringClass, factoryMethodName, args});
    }

    private CodeBlock generateReturnStatement(GeneratedMethod generatedMethod) {
        return generatedMethod.toMethodReference().toInvokeCodeBlock(MethodReference.ArgumentCodeGenerator.none(), this.className);
    }

    private CodeBlock generateWithGeneratorCode(boolean hasArguments, CodeBlock newInstance) {
        CodeBlock lambdaArguments = hasArguments ? CodeBlock.of((String)"($L, $L)", (Object[])new Object[]{REGISTERED_BEAN_PARAMETER_NAME, ARGS_PARAMETER_NAME}) : CodeBlock.of((String)"($L)", (Object[])new Object[]{REGISTERED_BEAN_PARAMETER_NAME});
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("\n", new Object[0]);
        code.indent().indent();
        code.add(".withGenerator($L -> $L)", new Object[]{lambdaArguments, newInstance});
        code.unindent().unindent();
        return code.build();
    }

    protected AccessVisibility getAccessVisibility(RegisteredBean registeredBean, Member member) {
        AccessVisibility beanTypeAccessVisibility = AccessVisibility.forResolvableType((ResolvableType)registeredBean.getBeanType());
        AccessVisibility memberAccessVisibility = AccessVisibility.forMember((Member)member);
        return AccessVisibility.lowest((AccessVisibility[])new AccessVisibility[]{beanTypeAccessVisibility, memberAccessVisibility});
    }

    private CodeBlock generateParameterTypesCode(Class<?>[] parameterTypes, int offset) {
        CodeBlock.Builder code = CodeBlock.builder();
        for (int i = offset; i < parameterTypes.length; ++i) {
            code.add(i != offset ? ", " : "", new Object[0]);
            code.add("$T.class", new Object[]{parameterTypes[i]});
        }
        return code.build();
    }

    private GeneratedMethod generateGetInstanceSupplierMethod(Consumer<MethodSpec.Builder> method) {
        return this.generatedMethods.add("getInstanceSupplier", method);
    }

    private boolean isThrowingCheckedException(Executable executable) {
        return Arrays.stream(executable.getGenericExceptionTypes()).map(ResolvableType::forType).map(ResolvableType::toClass).anyMatch(Exception.class::isAssignableFrom);
    }
}

