/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.util.List;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.AotBeanProcessingException;
import org.springframework.beans.factory.aot.AotException;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGenerator;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.aot.BeanRegistrationsCode;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;

class BeanRegistrationsAotContribution
implements BeanFactoryInitializationAotContribution {
    private static final String BEAN_FACTORY_PARAMETER_NAME = "beanFactory";
    private final List<Registration> registrations;

    BeanRegistrationsAotContribution(List<Registration> registrations) {
        this.registrations = registrations;
    }

    @Override
    public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
        GeneratedClass generatedClass = generationContext.getGeneratedClasses().addForFeature("BeanFactoryRegistrations", type -> {
            type.addJavadoc("Register bean definitions for the bean factory.", new Object[0]);
            type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        });
        BeanRegistrationsCodeGenerator codeGenerator = new BeanRegistrationsCodeGenerator(generatedClass);
        GeneratedMethod generatedBeanDefinitionsMethod = codeGenerator.getMethods().add("registerBeanDefinitions", method -> this.generateRegisterBeanDefinitionsMethod((MethodSpec.Builder)method, generationContext, codeGenerator));
        beanFactoryInitializationCode.addInitializer(generatedBeanDefinitionsMethod.toMethodReference());
        GeneratedMethod generatedAliasesMethod = codeGenerator.getMethods().add("registerAliases", this::generateRegisterAliasesMethod);
        beanFactoryInitializationCode.addInitializer(generatedAliasesMethod.toMethodReference());
        this.generateRegisterHints(generationContext.getRuntimeHints(), this.registrations);
    }

    private void generateRegisterBeanDefinitionsMethod(MethodSpec.Builder method, GenerationContext generationContext, BeanRegistrationsCode beanRegistrationsCode) {
        method.addJavadoc("Register the bean definitions.", new Object[0]);
        method.addModifiers(new Modifier[]{Modifier.PUBLIC});
        method.addParameter(DefaultListableBeanFactory.class, BEAN_FACTORY_PARAMETER_NAME, new Modifier[0]);
        CodeBlock.Builder code = CodeBlock.builder();
        this.registrations.forEach(registration -> {
            try {
                MethodReference beanDefinitionMethod = registration.methodGenerator.generateBeanDefinitionMethod(generationContext, beanRegistrationsCode);
                CodeBlock methodInvocation = beanDefinitionMethod.toInvokeCodeBlock(MethodReference.ArgumentCodeGenerator.none(), beanRegistrationsCode.getClassName());
                code.addStatement("$L.registerBeanDefinition($S, $L)", new Object[]{BEAN_FACTORY_PARAMETER_NAME, registration.beanName(), methodInvocation});
            }
            catch (AotException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new AotBeanProcessingException(registration.registeredBean, "failed to generate code for bean definition", ex);
            }
        });
        method.addCode(code.build());
    }

    private void generateRegisterAliasesMethod(MethodSpec.Builder method) {
        method.addJavadoc("Register the aliases.", new Object[0]);
        method.addModifiers(new Modifier[]{Modifier.PUBLIC});
        method.addParameter(DefaultListableBeanFactory.class, BEAN_FACTORY_PARAMETER_NAME, new Modifier[0]);
        CodeBlock.Builder code = CodeBlock.builder();
        this.registrations.forEach(registration -> {
            for (String alias : registration.aliases()) {
                code.addStatement("$L.registerAlias($S, $S)", new Object[]{BEAN_FACTORY_PARAMETER_NAME, registration.beanName(), alias});
            }
        });
        method.addCode(code.build());
    }

    private void generateRegisterHints(RuntimeHints runtimeHints, List<Registration> registrations) {
        registrations.forEach(registration -> {
            ReflectionHints hints = runtimeHints.reflection();
            Class<?> beanClass = registration.registeredBean.getBeanClass();
            hints.registerType(beanClass, new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_METHODS});
            hints.registerForInterfaces(beanClass, typeHint -> typeHint.withMembers(new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS}));
        });
    }

    static class BeanRegistrationsCodeGenerator
    implements BeanRegistrationsCode {
        private final GeneratedClass generatedClass;

        public BeanRegistrationsCodeGenerator(GeneratedClass generatedClass) {
            this.generatedClass = generatedClass;
        }

        @Override
        public ClassName getClassName() {
            return this.generatedClass.getName();
        }

        @Override
        public GeneratedMethods getMethods() {
            return this.generatedClass.getMethods();
        }
    }

    record Registration(RegisteredBean registeredBean, BeanDefinitionMethodGenerator methodGenerator, String[] aliases) {
        String beanName() {
            return this.registeredBean.getBeanName();
        }
    }
}

