/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.aot.ApplicationContextInitializationCodeGenerator;
import org.springframework.context.aot.BeanFactoryInitializationContributions;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.JavaFile;

public class ApplicationContextAotGenerator {
    public void generateApplicationContext(GenericApplicationContext applicationContext, GenerationContext generationContext, ClassName generatedInitializerClassName) {
        applicationContext.refreshForAotProcessing();
        DefaultListableBeanFactory beanFactory = applicationContext.getDefaultListableBeanFactory();
        ApplicationContextInitializationCodeGenerator codeGenerator = new ApplicationContextInitializationCodeGenerator();
        new BeanFactoryInitializationContributions(beanFactory).applyTo(generationContext, codeGenerator);
        JavaFile javaFile = codeGenerator.generateJavaFile(generatedInitializerClassName);
        generationContext.getGeneratedFiles().addSourceFile(javaFile);
    }
}

