/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.aot.AotFactoriesLoader;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.log.LogMessage;
import org.springframework.lang.Nullable;

class RuntimeHintsBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final Log logger = LogFactory.getLog(RuntimeHintsBeanFactoryInitializationAotProcessor.class);

    RuntimeHintsBeanFactoryInitializationAotProcessor() {
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        AotFactoriesLoader loader = new AotFactoriesLoader((ListableBeanFactory)beanFactory);
        ArrayList<RuntimeHintsRegistrar> registrars = new ArrayList<RuntimeHintsRegistrar>(loader.load(RuntimeHintsRegistrar.class));
        for (String beanName : beanFactory.getBeanNamesForAnnotation(ImportRuntimeHints.class)) {
            ImportRuntimeHints annotation = (ImportRuntimeHints)beanFactory.findAnnotationOnBean(beanName, ImportRuntimeHints.class);
            if (annotation == null) continue;
            registrars.addAll(this.extracted(beanName, annotation));
        }
        return new RuntimeHintsRegistrarContribution(registrars, beanFactory.getBeanClassLoader());
    }

    private List<RuntimeHintsRegistrar> extracted(String beanName, ImportRuntimeHints annotation) {
        Class<? extends RuntimeHintsRegistrar>[] registrarClasses = annotation.value();
        ArrayList<RuntimeHintsRegistrar> registrars = new ArrayList<RuntimeHintsRegistrar>(registrarClasses.length);
        for (Class<? extends RuntimeHintsRegistrar> registrarClass : registrarClasses) {
            logger.trace((Object)LogMessage.format((String)"Loaded [%s] registrar from annotated bean [%s]", (Object)registrarClass.getCanonicalName(), (Object)beanName));
            registrars.add((RuntimeHintsRegistrar)BeanUtils.instantiateClass(registrarClass));
        }
        return registrars;
    }

    static class RuntimeHintsRegistrarContribution
    implements BeanFactoryInitializationAotContribution {
        private final List<RuntimeHintsRegistrar> registrars;
        @Nullable
        private final ClassLoader beanClassLoader;

        RuntimeHintsRegistrarContribution(List<RuntimeHintsRegistrar> registrars, @Nullable ClassLoader beanClassLoader) {
            this.registrars = registrars;
            this.beanClassLoader = beanClassLoader;
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            RuntimeHints hints = generationContext.getRuntimeHints();
            this.registrars.forEach(registrar -> {
                logger.trace((Object)LogMessage.format((String)"Processing RuntimeHints contribution from [%s]", (Object)registrar.getClass().getCanonicalName()));
                registrar.registerHints(hints, this.beanClassLoader);
            });
        }
    }
}

