/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.aot.ApplicationContextInitializationCodeGenerator;
import org.springframework.context.aot.BeanFactoryInitializationAotContributions;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.javapoet.ClassName;

public class ApplicationContextAotGenerator {
    public ClassName generateApplicationContext(GenericApplicationContext applicationContext, GenerationContext generationContext) {
        applicationContext.refreshForAotProcessing();
        DefaultListableBeanFactory beanFactory = applicationContext.getDefaultListableBeanFactory();
        ApplicationContextInitializationCodeGenerator codeGenerator = new ApplicationContextInitializationCodeGenerator();
        new BeanFactoryInitializationAotContributions(beanFactory).applyTo(generationContext, codeGenerator);
        GeneratedClass applicationContextInitializer = generationContext.getGeneratedClasses().forFeature("ApplicationContextInitializer").generate(codeGenerator.generateJavaFile());
        return applicationContextInitializer.getName();
    }
}

