/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.MethodGenerator;
import org.springframework.aot.generate.MethodReference;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.TypeSpec;

class ApplicationContextInitializationCodeGenerator
implements BeanFactoryInitializationCode {
    private static final String APPLICATION_CONTEXT_VARIABLE = "applicationContext";
    private final GeneratedMethods generatedMethods = new GeneratedMethods();
    private final List<MethodReference> initializers = new ArrayList<MethodReference>();

    ApplicationContextInitializationCodeGenerator() {
    }

    public MethodGenerator getMethodGenerator() {
        return this.generatedMethods;
    }

    public void addInitializer(MethodReference methodReference) {
        this.initializers.add(methodReference);
    }

    Consumer<TypeSpec.Builder> generateJavaFile() {
        return builder -> {
            builder.addJavadoc("{@link $T} to restore an application context based on previous AOT processing.", new Object[]{ApplicationContextInitializer.class});
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
            builder.addSuperinterface((TypeName)ParameterizedTypeName.get(ApplicationContextInitializer.class, (Type[])new Type[]{GenericApplicationContext.class}));
            builder.addMethod(this.generateInitializeMethod());
            this.generatedMethods.doWithMethodSpecs(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        };
    }

    private MethodSpec generateInitializeMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"initialize");
        builder.addAnnotation(Override.class);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addParameter(GenericApplicationContext.class, APPLICATION_CONTEXT_VARIABLE, new Modifier[0]);
        builder.addCode(this.generateInitializeCode());
        return builder.build();
    }

    private CodeBlock generateInitializeCode() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.addStatement("$T $L = $L.getDefaultListableBeanFactory()", new Object[]{DefaultListableBeanFactory.class, "beanFactory", APPLICATION_CONTEXT_VARIABLE});
        builder.addStatement("$L.setAutowireCandidateResolver(new $T())", new Object[]{"beanFactory", ContextAnnotationAutowireCandidateResolver.class});
        for (MethodReference initializer : this.initializers) {
            builder.addStatement(initializer.toInvokeCodeBlock(new CodeBlock[]{CodeBlock.of((String)"beanFactory", (Object[])new Object[0])}));
        }
        return builder.build();
    }
}

