/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.aot.AotFactoriesLoader;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.aot.RuntimeHintsBeanFactoryInitializationAotProcessor;

class BeanFactoryInitializationAotContributions {
    private final List<BeanFactoryInitializationAotContribution> contributions;

    BeanFactoryInitializationAotContributions(DefaultListableBeanFactory beanFactory) {
        this(beanFactory, new AotFactoriesLoader((ListableBeanFactory)beanFactory));
    }

    BeanFactoryInitializationAotContributions(DefaultListableBeanFactory beanFactory, AotFactoriesLoader loader) {
        this.contributions = this.getContributions(beanFactory, this.getProcessors(loader));
    }

    private List<BeanFactoryInitializationAotProcessor> getProcessors(AotFactoriesLoader loader) {
        ArrayList<RuntimeHintsBeanFactoryInitializationAotProcessor> processors = new ArrayList<RuntimeHintsBeanFactoryInitializationAotProcessor>(loader.load(BeanFactoryInitializationAotProcessor.class));
        processors.add(new RuntimeHintsBeanFactoryInitializationAotProcessor());
        return Collections.unmodifiableList(processors);
    }

    private List<BeanFactoryInitializationAotContribution> getContributions(DefaultListableBeanFactory beanFactory, List<BeanFactoryInitializationAotProcessor> processors) {
        ArrayList<BeanFactoryInitializationAotContribution> contributions = new ArrayList<BeanFactoryInitializationAotContribution>();
        for (BeanFactoryInitializationAotProcessor processor : processors) {
            BeanFactoryInitializationAotContribution contribution = processor.processAheadOfTime((ConfigurableListableBeanFactory)beanFactory);
            if (contribution == null) continue;
            contributions.add(contribution);
        }
        return Collections.unmodifiableList(contributions);
    }

    void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
        for (BeanFactoryInitializationAotContribution contribution : this.contributions) {
            contribution.applyTo(generationContext, beanFactoryInitializationCode);
        }
    }
}

