/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.annotation.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.security.Principal;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.annotation.support.DestinationVariableMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.messaging.simp.annotation.support.MissingSessionUserException;
import org.springframework.messaging.simp.user.DestinationUserNameProvider;
import org.springframework.messaging.support.MessageHeaderInitializer;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.util.StringUtils;

public class SendToMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final SimpMessageSendingOperations messagingTemplate;
    private final boolean annotationRequired;
    private String defaultDestinationPrefix = "/topic";
    private String defaultUserDestinationPrefix = "/queue";
    private PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("{", "}", null, false);
    private MessageHeaderInitializer headerInitializer;

    public SendToMethodReturnValueHandler(SimpMessageSendingOperations messagingTemplate, boolean annotationRequired) {
        Assert.notNull((Object)messagingTemplate, (String)"messagingTemplate must not be null");
        this.messagingTemplate = messagingTemplate;
        this.annotationRequired = annotationRequired;
    }

    public void setDefaultDestinationPrefix(String defaultDestinationPrefix) {
        this.defaultDestinationPrefix = defaultDestinationPrefix;
    }

    public String getDefaultDestinationPrefix() {
        return this.defaultDestinationPrefix;
    }

    public void setDefaultUserDestinationPrefix(String prefix) {
        this.defaultUserDestinationPrefix = prefix;
    }

    public String getDefaultUserDestinationPrefix() {
        return this.defaultUserDestinationPrefix;
    }

    public void setHeaderInitializer(MessageHeaderInitializer headerInitializer) {
        this.headerInitializer = headerInitializer;
    }

    public MessageHeaderInitializer getHeaderInitializer() {
        return this.headerInitializer;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        if (returnType.hasMethodAnnotation(SendTo.class) || AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnType.getDeclaringClass(), SendTo.class) || returnType.hasMethodAnnotation(SendToUser.class) || AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnType.getDeclaringClass(), SendToUser.class)) {
            return true;
        }
        return !this.annotationRequired;
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType, Message<?> message) throws Exception {
        if (returnValue == null) {
            return;
        }
        MessageHeaders headers = message.getHeaders();
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);
        PropertyPlaceholderHelper.PlaceholderResolver varResolver = this.initVarResolver(headers);
        Object annotation = this.findAnnotation(returnType);
        if (annotation != null && annotation instanceof SendToUser) {
            String[] destinations;
            SendToUser sendToUser = (SendToUser)annotation;
            boolean broadcast = sendToUser.broadcast();
            String user = this.getUserName(message, headers);
            if (user == null) {
                if (sessionId == null) {
                    throw new MissingSessionUserException(message);
                }
                user = sessionId;
                broadcast = false;
            }
            for (String destination : destinations = this.getTargetDestinations(sendToUser, message, this.defaultUserDestinationPrefix)) {
                destination = this.placeholderHelper.replacePlaceholders(destination, varResolver);
                if (broadcast) {
                    this.messagingTemplate.convertAndSendToUser(user, destination, returnValue, this.createHeaders(null, returnType));
                    continue;
                }
                this.messagingTemplate.convertAndSendToUser(user, destination, returnValue, this.createHeaders(sessionId, returnType));
            }
        } else {
            String[] destinations;
            SendTo sendTo = (SendTo)annotation;
            for (String destination : destinations = this.getTargetDestinations(sendTo, message, this.defaultDestinationPrefix)) {
                destination = this.placeholderHelper.replacePlaceholders(destination, varResolver);
                this.messagingTemplate.convertAndSend(destination, returnValue, this.createHeaders(sessionId, returnType));
            }
        }
    }

    private Object findAnnotation(MethodParameter returnType) {
        Annotation[] annot = new Annotation[]{AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getMethod(), SendToUser.class), AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getMethod(), SendTo.class), AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getDeclaringClass(), SendToUser.class), AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getDeclaringClass(), SendTo.class)};
        if (annot[0] != null && !ObjectUtils.isEmpty((Object[])((SendToUser)annot[0]).value())) {
            return annot[0];
        }
        if (annot[1] != null && !ObjectUtils.isEmpty((Object[])((SendTo)annot[1]).value())) {
            return annot[1];
        }
        if (annot[2] != null && !ObjectUtils.isEmpty((Object[])((SendToUser)annot[2]).value())) {
            return annot[2];
        }
        if (annot[3] != null && !ObjectUtils.isEmpty((Object[])((SendTo)annot[3]).value())) {
            return annot[3];
        }
        for (int i = 0; i < 4; ++i) {
            if (annot[i] == null) continue;
            return annot[i];
        }
        return null;
    }

    private SendToUser getSendToUser(MethodParameter returnType) {
        SendToUser annot = (SendToUser)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getMethod(), SendToUser.class);
        if (annot != null && !ObjectUtils.isEmpty((Object[])annot.value())) {
            return annot;
        }
        SendToUser typeAnnot = (SendToUser)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getDeclaringClass(), SendToUser.class);
        if (typeAnnot != null && !ObjectUtils.isEmpty((Object[])typeAnnot.value())) {
            return typeAnnot;
        }
        return annot != null ? annot : typeAnnot;
    }

    private SendTo getSendTo(MethodParameter returnType) {
        SendTo sendTo = (SendTo)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getMethod(), SendTo.class);
        if (sendTo != null && !ObjectUtils.isEmpty((Object[])sendTo.value())) {
            return sendTo;
        }
        return (SendTo)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getDeclaringClass(), SendTo.class);
    }

    private PropertyPlaceholderHelper.PlaceholderResolver initVarResolver(MessageHeaders headers) {
        String name = DestinationVariableMethodArgumentResolver.DESTINATION_TEMPLATE_VARIABLES_HEADER;
        Map vars = (Map)headers.get(name);
        return new DestinationVariablePlaceholderResolver(vars);
    }

    protected String getUserName(Message<?> message, MessageHeaders headers) {
        Principal principal = SimpMessageHeaderAccessor.getUser(headers);
        if (principal != null) {
            return principal instanceof DestinationUserNameProvider ? ((DestinationUserNameProvider)((Object)principal)).getDestinationUserName() : principal.getName();
        }
        return null;
    }

    protected String[] getTargetDestinations(Annotation annotation, Message<?> message, String defaultPrefix) {
        String[] stringArray;
        Object[] value;
        if (annotation != null && !ObjectUtils.isEmpty((Object[])(value = (String[])AnnotationUtils.getValue((Annotation)annotation)))) {
            return value;
        }
        String name = "lookupDestination";
        String destination = (String)message.getHeaders().get(name);
        if (!StringUtils.hasText((String)destination)) {
            throw new IllegalStateException("No lookup destination header in " + message);
        }
        if (destination.startsWith("/")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = defaultPrefix + destination;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = defaultPrefix + "/" + destination;
        }
        return stringArray;
    }

    private MessageHeaders createHeaders(String sessionId, MethodParameter returnType) {
        SimpMessageHeaderAccessor headerAccessor = SimpMessageHeaderAccessor.create(SimpMessageType.MESSAGE);
        if (this.getHeaderInitializer() != null) {
            this.getHeaderInitializer().initHeaders(headerAccessor);
        }
        if (sessionId != null) {
            headerAccessor.setSessionId(sessionId);
        }
        headerAccessor.setHeader("conversionHint", returnType);
        headerAccessor.setLeaveMutable(true);
        return headerAccessor.getMessageHeaders();
    }

    public String toString() {
        return "SendToMethodReturnValueHandler [annotationRequired=" + this.annotationRequired + "]";
    }

    private static class DestinationVariablePlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final Map<String, String> vars;

        public DestinationVariablePlaceholderResolver(Map<String, String> vars) {
            this.vars = vars;
        }

        public String resolvePlaceholder(String placeholderName) {
            return this.vars != null ? this.vars.get(placeholderName) : null;
        }
    }
}

