/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.sessions.ObjectCopyingPolicy;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SessionFactoryUtils;
import org.springframework.orm.toplink.SessionReadCallback;
import org.springframework.orm.toplink.TopLinkAccessor;
import org.springframework.orm.toplink.TopLinkCallback;
import org.springframework.orm.toplink.TopLinkOperations;
import org.springframework.orm.toplink.UnitOfWorkCallback;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TopLinkTemplate
extends TopLinkAccessor
implements TopLinkOperations {
    private boolean allowCreate = true;

    public TopLinkTemplate() {
    }

    public TopLinkTemplate(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.afterPropertiesSet();
    }

    public TopLinkTemplate(SessionFactory sessionFactory, boolean allowCreate) {
        this.setSessionFactory(sessionFactory);
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public Object execute(TopLinkCallback action) throws DataAccessException {
        Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), this.allowCreate);
        try {
            Object object = action.doInTopLink(session);
            return object;
        }
        catch (TopLinkException ex) {
            throw this.convertTopLinkAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
        }
    }

    public List executeFind(TopLinkCallback action) throws DataAccessException {
        Object result = this.execute(action);
        if (result != null && !(result instanceof List)) {
            throw new InvalidDataAccessApiUsageException("Result object returned from TopLinkCallback isn't a List: [" + result + "]");
        }
        return (List)result;
    }

    public Object executeNamedQuery(Class entityClass, String queryName) throws DataAccessException {
        return this.executeNamedQuery(entityClass, queryName, null, false);
    }

    public Object executeNamedQuery(Class entityClass, String queryName, boolean enforceReadOnly) throws DataAccessException {
        return this.executeNamedQuery(entityClass, queryName, null, enforceReadOnly);
    }

    public Object executeNamedQuery(Class entityClass, String queryName, Object[] args) throws DataAccessException {
        return this.executeNamedQuery(entityClass, queryName, args, false);
    }

    public Object executeNamedQuery(final Class entityClass, final String queryName, final Object[] args, boolean enforceReadOnly) throws DataAccessException {
        return this.execute(new SessionReadCallback(enforceReadOnly){

            protected Object readFromSession(Session session) throws TopLinkException {
                if (args != null) {
                    return session.executeQuery(queryName, entityClass, new Vector<Object>(Arrays.asList(args)));
                }
                return session.executeQuery(queryName, entityClass, new Vector());
            }
        });
    }

    public Object executeQuery(DatabaseQuery query) throws DataAccessException {
        return this.executeQuery(query, null, false);
    }

    public Object executeQuery(DatabaseQuery query, boolean enforceReadOnly) throws DataAccessException {
        return this.executeQuery(query, null, enforceReadOnly);
    }

    public Object executeQuery(DatabaseQuery query, Object[] args) throws DataAccessException {
        return this.executeQuery(query, args, false);
    }

    public Object executeQuery(final DatabaseQuery query, final Object[] args, boolean enforceReadOnly) throws DataAccessException {
        return this.execute(new SessionReadCallback(enforceReadOnly){

            protected Object readFromSession(Session session) throws TopLinkException {
                if (args != null) {
                    return session.executeQuery(query, new Vector<Object>(Arrays.asList(args)));
                }
                return session.executeQuery(query);
            }
        });
    }

    public List readAll(Class entityClass) throws DataAccessException {
        return this.readAll(entityClass, false);
    }

    public List readAll(final Class entityClass, boolean enforceReadOnly) throws DataAccessException {
        return this.executeFind(new SessionReadCallback(enforceReadOnly){

            protected Object readFromSession(Session session) throws TopLinkException {
                return session.readAllObjects(entityClass);
            }
        });
    }

    public List readAll(Class entityClass, Expression expression) throws DataAccessException {
        return this.readAll(entityClass, expression, false);
    }

    public List readAll(final Class entityClass, final Expression expression, boolean enforceReadOnly) throws DataAccessException {
        return this.executeFind(new SessionReadCallback(enforceReadOnly){

            protected Object readFromSession(Session session) throws TopLinkException {
                return session.readAllObjects(entityClass, expression);
            }
        });
    }

    public List readAll(Class entityClass, Call call) throws DataAccessException {
        return this.readAll(entityClass, call, false);
    }

    public List readAll(final Class entityClass, final Call call, boolean enforceReadOnly) throws DataAccessException {
        return this.executeFind(new SessionReadCallback(enforceReadOnly){

            protected Object readFromSession(Session session) throws TopLinkException {
                return session.readAllObjects(entityClass, call);
            }
        });
    }

    public Object read(Class entityClass, Expression expression) throws DataAccessException {
        return this.read(entityClass, expression, false);
    }

    public Object read(final Class entityClass, final Expression expression, boolean enforceReadOnly) throws DataAccessException {
        return this.execute(new SessionReadCallback(enforceReadOnly){

            protected Object readFromSession(Session session) throws TopLinkException {
                return session.readObject(entityClass, expression);
            }
        });
    }

    public Object read(Class entityClass, Call call) throws DataAccessException {
        return this.read(entityClass, call, false);
    }

    public Object read(final Class entityClass, final Call call, boolean enforceReadOnly) throws DataAccessException {
        return this.execute(new SessionReadCallback(enforceReadOnly){

            protected Object readFromSession(Session session) throws TopLinkException {
                return session.readObject(entityClass, call);
            }
        });
    }

    public Object readById(Class entityClass, Object id) throws DataAccessException {
        return this.readById(entityClass, id, false);
    }

    public Object readById(Class entityClass, Object id, boolean enforceReadOnly) throws DataAccessException {
        return this.readById(entityClass, new Object[]{id}, enforceReadOnly);
    }

    public Object readById(Class entityClass, Object[] keys) throws DataAccessException {
        return this.readById(entityClass, keys, false);
    }

    public Object readById(Class entityClass, Object[] keys, boolean enforceReadOnly) throws DataAccessException {
        Assert.isTrue((keys != null && keys.length > 0 ? 1 : 0) != 0, (String)"Non-empty keys or id is required");
        ReadObjectQuery query = new ReadObjectQuery(entityClass);
        query.setSelectionKey(new Vector<Object>(Arrays.asList(keys)));
        Object result = this.executeQuery((DatabaseQuery)query, enforceReadOnly);
        if (result == null) {
            Object identifier = keys.length == 1 ? keys[0] : StringUtils.arrayToCommaDelimitedString((Object[])keys);
            throw new ObjectRetrievalFailureException(entityClass, identifier);
        }
        return result;
    }

    public Object readAndCopy(Class entityClass, Object id) throws DataAccessException {
        return this.readAndCopy(entityClass, id, false);
    }

    public Object readAndCopy(Class entityClass, Object id, boolean enforceReadOnly) throws DataAccessException {
        Object entity = this.readById(entityClass, id, enforceReadOnly);
        return this.copy(entity);
    }

    public Object readAndCopy(Class entityClass, Object[] keys) throws DataAccessException {
        return this.readAndCopy(entityClass, keys, false);
    }

    public Object readAndCopy(Class entityClass, Object[] keys, boolean enforceReadOnly) throws DataAccessException {
        Object entity = this.readById(entityClass, keys, enforceReadOnly);
        return this.copy(entity);
    }

    public Object copy(Object entity) throws DataAccessException {
        ObjectCopyingPolicy copyingPolicy = new ObjectCopyingPolicy();
        copyingPolicy.cascadeAllParts();
        copyingPolicy.setShouldResetPrimaryKey(false);
        return this.copy(entity, copyingPolicy);
    }

    public Object copy(final Object entity, final ObjectCopyingPolicy copyingPolicy) throws DataAccessException {
        return this.execute(new TopLinkCallback(){

            public Object doInTopLink(Session session) throws TopLinkException {
                return session.copyObject(entity, copyingPolicy);
            }
        });
    }

    public List copyAll(Collection entities) throws DataAccessException {
        ObjectCopyingPolicy copyingPolicy = new ObjectCopyingPolicy();
        copyingPolicy.cascadeAllParts();
        copyingPolicy.setShouldResetPrimaryKey(false);
        return this.copyAll(entities, copyingPolicy);
    }

    public List copyAll(final Collection entities, final ObjectCopyingPolicy copyingPolicy) throws DataAccessException {
        return (List)this.execute(new TopLinkCallback(){

            public Object doInTopLink(Session session) throws TopLinkException {
                ArrayList<Object> result = new ArrayList<Object>(entities.size());
                Iterator it = entities.iterator();
                while (it.hasNext()) {
                    Object entity = it.next();
                    result.add(session.copyObject(entity, copyingPolicy));
                }
                return result;
            }
        });
    }

    public Object refresh(Object entity) throws DataAccessException {
        return this.refresh(entity, false);
    }

    public Object refresh(final Object entity, boolean enforceReadOnly) throws DataAccessException {
        return this.execute(new SessionReadCallback(enforceReadOnly){

            protected Object readFromSession(Session session) throws TopLinkException {
                return session.refreshObject(entity);
            }
        });
    }

    public List refreshAll(Collection entities) throws DataAccessException {
        return this.refreshAll(entities, false);
    }

    public List refreshAll(final Collection entities, boolean enforceReadOnly) throws DataAccessException {
        return (List)this.execute(new SessionReadCallback(enforceReadOnly){

            protected Object readFromSession(Session session) throws TopLinkException {
                ArrayList<Object> result = new ArrayList<Object>(entities.size());
                Iterator it = entities.iterator();
                while (it.hasNext()) {
                    Object entity = it.next();
                    result.add(session.refreshObject(entity));
                }
                return result;
            }
        });
    }

    public Object register(final Object entity) {
        return this.execute(new UnitOfWorkCallback(){

            protected Object doInUnitOfWork(UnitOfWork unitOfWork) throws TopLinkException {
                return unitOfWork.registerObject(entity);
            }
        });
    }

    public List registerAll(final Collection entities) {
        return (List)this.execute(new UnitOfWorkCallback(){

            protected Object doInUnitOfWork(UnitOfWork unitOfWork) throws TopLinkException {
                return unitOfWork.registerAllObjects(entities);
            }
        });
    }

    public void registerNew(final Object entity) {
        this.execute(new UnitOfWorkCallback(){

            protected Object doInUnitOfWork(UnitOfWork unitOfWork) throws TopLinkException {
                return unitOfWork.registerNewObject(entity);
            }
        });
    }

    public Object registerExisting(final Object entity) {
        return this.execute(new UnitOfWorkCallback(){

            protected Object doInUnitOfWork(UnitOfWork unitOfWork) throws TopLinkException {
                return unitOfWork.registerExistingObject(entity);
            }
        });
    }

    public Object merge(final Object entity) throws DataAccessException {
        return this.execute(new UnitOfWorkCallback(){

            protected Object doInUnitOfWork(UnitOfWork unitOfWork) throws TopLinkException {
                return unitOfWork.mergeClone(entity);
            }
        });
    }

    public Object deepMerge(final Object entity) throws DataAccessException {
        return this.execute(new UnitOfWorkCallback(){

            protected Object doInUnitOfWork(UnitOfWork unitOfWork) throws TopLinkException {
                return unitOfWork.deepMergeClone(entity);
            }
        });
    }

    public Object shallowMerge(final Object entity) throws DataAccessException {
        return this.execute(new UnitOfWorkCallback(){

            protected Object doInUnitOfWork(UnitOfWork unitOfWork) throws TopLinkException {
                return unitOfWork.shallowMergeClone(entity);
            }
        });
    }

    public Object mergeWithReferences(final Object entity) throws DataAccessException {
        return this.execute(new UnitOfWorkCallback(){

            protected Object doInUnitOfWork(UnitOfWork unitOfWork) throws TopLinkException {
                return unitOfWork.mergeCloneWithReferences(entity);
            }
        });
    }

    public void delete(final Object entity) throws DataAccessException {
        this.execute(new UnitOfWorkCallback(){

            protected Object doInUnitOfWork(UnitOfWork unitOfWork) throws TopLinkException {
                return unitOfWork.deleteObject(entity);
            }
        });
    }

    public void deleteAll(final Collection entities) throws DataAccessException {
        this.execute(new UnitOfWorkCallback(){

            protected Object doInUnitOfWork(UnitOfWork unitOfWork) throws TopLinkException {
                unitOfWork.deleteAllObjects(entities);
                return null;
            }
        });
    }
}

