/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Conventions;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletWebRequest;

public class ServletTestExecutionListener
extends AbstractTestExecutionListener {
    public static final String RESET_REQUEST_CONTEXT_HOLDER_ATTRIBUTE = Conventions.getQualifiedAttributeName(ServletTestExecutionListener.class, (String)"resetRequestContextHolder");
    public static final String POPULATED_REQUEST_CONTEXT_HOLDER_ATTRIBUTE = Conventions.getQualifiedAttributeName(ServletTestExecutionListener.class, (String)"populatedRequestContextHolder");
    private static final Log logger = LogFactory.getLog(ServletTestExecutionListener.class);

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        this.setUpRequestContextIfNecessary(testContext);
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.setUpRequestContextIfNecessary(testContext);
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        if (Boolean.TRUE.equals(testContext.getAttribute(RESET_REQUEST_CONTEXT_HOLDER_ATTRIBUTE))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Resetting RequestContextHolder for test context %s.", testContext));
            }
            RequestContextHolder.resetRequestAttributes();
            testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, Boolean.TRUE);
        }
        testContext.removeAttribute(POPULATED_REQUEST_CONTEXT_HOLDER_ATTRIBUTE);
        testContext.removeAttribute(RESET_REQUEST_CONTEXT_HOLDER_ATTRIBUTE);
    }

    private boolean notAnnotatedWithWebAppConfiguration(TestContext testContext) {
        return AnnotationUtils.findAnnotation(testContext.getTestClass(), WebAppConfiguration.class) == null;
    }

    private boolean alreadyPopulatedRequestContextHolder(TestContext testContext) {
        return Boolean.TRUE.equals(testContext.getAttribute(POPULATED_REQUEST_CONTEXT_HOLDER_ATTRIBUTE));
    }

    private void setUpRequestContextIfNecessary(TestContext testContext) {
        if (this.notAnnotatedWithWebAppConfiguration(testContext) || this.alreadyPopulatedRequestContextHolder(testContext)) {
            return;
        }
        ApplicationContext context = testContext.getApplicationContext();
        if (context instanceof WebApplicationContext) {
            WebApplicationContext wac = (WebApplicationContext)context;
            ServletContext servletContext = wac.getServletContext();
            Assert.state((boolean)(servletContext instanceof MockServletContext), (String)String.format("The WebApplicationContext for test context %s must be configured with a MockServletContext.", testContext));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Setting up MockHttpServletRequest, MockHttpServletResponse, ServletWebRequest, and RequestContextHolder for test context %s.", testContext));
            }
            MockServletContext mockServletContext = (MockServletContext)servletContext;
            MockHttpServletRequest request = new MockHttpServletRequest(mockServletContext);
            MockHttpServletResponse response = new MockHttpServletResponse();
            ServletWebRequest servletWebRequest = new ServletWebRequest((HttpServletRequest)request, (HttpServletResponse)response);
            RequestContextHolder.setRequestAttributes((RequestAttributes)servletWebRequest);
            testContext.setAttribute(POPULATED_REQUEST_CONTEXT_HOLDER_ATTRIBUTE, Boolean.TRUE);
            testContext.setAttribute(RESET_REQUEST_CONTEXT_HOLDER_ATTRIBUTE, Boolean.TRUE);
            if (wac instanceof ConfigurableApplicationContext) {
                ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)wac;
                ConfigurableListableBeanFactory bf = configurableApplicationContext.getBeanFactory();
                bf.registerResolvableDependency(MockHttpServletResponse.class, (Object)response);
                bf.registerResolvableDependency(ServletWebRequest.class, (Object)servletWebRequest);
            }
        }
    }
}

