/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.web.servlet.ModelAndView;

public class ViewResultMatchers {
    protected ViewResultMatchers() {
    }

    public ResultMatcher name(final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                ModelAndView mav = result.getModelAndView();
                AssertionErrors.assertTrue("No ModelAndView found", mav != null);
                MatcherAssert.assertThat((String)"View name", (Object)mav.getViewName(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher name(final String expectedViewName) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                ModelAndView mav = result.getModelAndView();
                AssertionErrors.assertTrue("No ModelAndView found", mav != null);
                AssertionErrors.assertEquals("View name", expectedViewName, mav.getViewName());
            }
        };
    }
}

