/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.core.SpringProperties;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.NestedTestConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentLruCache;
import org.springframework.util.ObjectUtils;

public abstract class TestContextAnnotationUtils {
    private static final ConcurrentLruCache<Class<?>, NestedTestConfiguration.EnclosingConfiguration> cachedEnclosingConfigurationModes = new ConcurrentLruCache(32, TestContextAnnotationUtils::lookUpEnclosingConfiguration);
    @Nullable
    private static volatile NestedTestConfiguration.EnclosingConfiguration defaultEnclosingConfigurationMode;

    public static boolean hasAnnotation(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return MergedAnnotations.search((MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).withEnclosingClasses(TestContextAnnotationUtils::searchEnclosingClass).from(clazz).isPresent(annotationType);
    }

    @Nullable
    public static <T extends Annotation> T findMergedAnnotation(Class<?> clazz, Class<T> annotationType) {
        return TestContextAnnotationUtils.findMergedAnnotation(clazz, annotationType, TestContextAnnotationUtils::searchEnclosingClass);
    }

    @Nullable
    private static <T extends Annotation> T findMergedAnnotation(Class<?> clazz, Class<T> annotationType, Predicate<Class<?>> searchEnclosingClass) {
        return (T)((Annotation)MergedAnnotations.search((MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).withEnclosingClasses(searchEnclosingClass).from(clazz).get(annotationType).synthesize(MergedAnnotation::isPresent).orElse(null));
    }

    public static <T extends Annotation> Set<T> getMergedRepeatableAnnotations(Class<?> clazz, Class<T> annotationType) {
        Set mergedAnnotations = (Set)MergedAnnotations.from(clazz, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).stream(annotationType).collect(MergedAnnotationCollectors.toAnnotationSet());
        if (!mergedAnnotations.isEmpty()) {
            return mergedAnnotations;
        }
        if (TestContextAnnotationUtils.searchEnclosingClass(clazz)) {
            return TestContextAnnotationUtils.getMergedRepeatableAnnotations(clazz.getEnclosingClass(), annotationType);
        }
        return Collections.emptySet();
    }

    @Nullable
    public static <T extends Annotation> AnnotationDescriptor<T> findAnnotationDescriptor(Class<?> clazz, Class<T> annotationType) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null");
        return TestContextAnnotationUtils.findAnnotationDescriptor(clazz, annotationType, TestContextAnnotationUtils::searchEnclosingClass, new HashSet<Annotation>());
    }

    @Nullable
    private static <T extends Annotation> AnnotationDescriptor<T> findAnnotationDescriptor(@Nullable Class<?> clazz, Class<T> annotationType, Predicate<Class<?>> searchEnclosingClass, Set<Annotation> visited) {
        if (clazz == null || Object.class == clazz) {
            return null;
        }
        if (AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) {
            return new AnnotationDescriptor<T>(clazz, clazz.getAnnotation(annotationType));
        }
        AnnotationDescriptor<T> descriptor = null;
        for (Annotation composedAnn : clazz.getDeclaredAnnotations()) {
            Class<? extends Annotation> composedType = composedAnn.annotationType();
            if (AnnotationUtils.isInJavaLangAnnotationPackage((String)composedType.getName()) || !visited.add(composedAnn) || (descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(composedType, annotationType, searchEnclosingClass, visited)) == null) continue;
            return new AnnotationDescriptor<T>(clazz, descriptor.getDeclaringClass(), descriptor.getAnnotation());
        }
        for (Class<?> ifc : clazz.getInterfaces()) {
            descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(ifc, annotationType, searchEnclosingClass, visited);
            if (descriptor == null) continue;
            return new AnnotationDescriptor<T>(clazz, descriptor.getDeclaringClass(), descriptor.getAnnotation());
        }
        descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(clazz.getSuperclass(), annotationType, searchEnclosingClass, visited);
        if (descriptor != null) {
            return descriptor;
        }
        if (searchEnclosingClass.test(clazz) && (descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(clazz.getEnclosingClass(), annotationType, searchEnclosingClass, visited)) != null) {
            return descriptor;
        }
        return null;
    }

    @Nullable
    public static UntypedAnnotationDescriptor findAnnotationDescriptorForTypes(Class<?> clazz, Class<? extends Annotation> ... annotationTypes) {
        TestContextAnnotationUtils.assertNonEmptyAnnotationTypeArray(annotationTypes, "The list of annotation types must not be empty");
        return TestContextAnnotationUtils.findAnnotationDescriptorForTypes(clazz, annotationTypes, new HashSet<Annotation>());
    }

    @Nullable
    private static UntypedAnnotationDescriptor findAnnotationDescriptorForTypes(@Nullable Class<?> clazz, Class<? extends Annotation>[] annotationTypes, Set<Annotation> visited) {
        UntypedAnnotationDescriptor descriptor;
        if (clazz == null || Object.class == clazz) {
            return null;
        }
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            if (!AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) continue;
            return new UntypedAnnotationDescriptor(clazz, clazz.getAnnotation(annotationType), annotationTypes);
        }
        for (Annotation composedAnnotation : clazz.getDeclaredAnnotations()) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage((Annotation)composedAnnotation) || !visited.add(composedAnnotation) || (descriptor = TestContextAnnotationUtils.findAnnotationDescriptorForTypes(composedAnnotation.annotationType(), annotationTypes, visited)) == null) continue;
            return new UntypedAnnotationDescriptor(clazz, descriptor.getDeclaringClass(), (Annotation)descriptor.getAnnotation(), annotationTypes);
        }
        for (Class<?> ifc : clazz.getInterfaces()) {
            descriptor = TestContextAnnotationUtils.findAnnotationDescriptorForTypes(ifc, annotationTypes, visited);
            if (descriptor == null) continue;
            return new UntypedAnnotationDescriptor(clazz, descriptor.getDeclaringClass(), (Annotation)descriptor.getAnnotation(), annotationTypes);
        }
        UntypedAnnotationDescriptor descriptor2 = TestContextAnnotationUtils.findAnnotationDescriptorForTypes(clazz.getSuperclass(), annotationTypes, visited);
        if (descriptor2 != null) {
            return descriptor2;
        }
        if (TestContextAnnotationUtils.searchEnclosingClass(clazz) && (descriptor2 = TestContextAnnotationUtils.findAnnotationDescriptorForTypes(clazz.getEnclosingClass(), annotationTypes, visited)) != null) {
            return descriptor2;
        }
        return null;
    }

    public static boolean searchEnclosingClass(Class<?> clazz) {
        return ClassUtils.isInnerClass(clazz) && TestContextAnnotationUtils.getEnclosingConfiguration(clazz) == NestedTestConfiguration.EnclosingConfiguration.INHERIT;
    }

    static void clearCaches() {
        cachedEnclosingConfigurationModes.clear();
        defaultEnclosingConfigurationMode = null;
    }

    private static NestedTestConfiguration.EnclosingConfiguration getEnclosingConfiguration(Class<?> clazz) {
        return (NestedTestConfiguration.EnclosingConfiguration)((Object)cachedEnclosingConfigurationModes.get(clazz));
    }

    private static NestedTestConfiguration.EnclosingConfiguration lookUpEnclosingConfiguration(Class<?> clazz) {
        Predicate<Class<?>> searchEnclosingClass = ClassUtils::isInnerClass;
        NestedTestConfiguration nestedTestConfiguration = TestContextAnnotationUtils.findMergedAnnotation(clazz, NestedTestConfiguration.class, searchEnclosingClass);
        return nestedTestConfiguration != null ? nestedTestConfiguration.value() : TestContextAnnotationUtils.getDefaultEnclosingConfigurationMode();
    }

    private static NestedTestConfiguration.EnclosingConfiguration getDefaultEnclosingConfigurationMode() {
        NestedTestConfiguration.EnclosingConfiguration defaultConfigurationMode = defaultEnclosingConfigurationMode;
        if (defaultConfigurationMode == null) {
            String value = SpringProperties.getProperty((String)"spring.test.enclosing.configuration");
            NestedTestConfiguration.EnclosingConfiguration enclosingConfigurationMode = NestedTestConfiguration.EnclosingConfiguration.from(value);
            defaultEnclosingConfigurationMode = defaultConfigurationMode = enclosingConfigurationMode != null ? enclosingConfigurationMode : NestedTestConfiguration.EnclosingConfiguration.INHERIT;
        }
        return defaultConfigurationMode;
    }

    private static void assertNonEmptyAnnotationTypeArray(Class<?>[] annotationTypes, String message) {
        if (ObjectUtils.isEmpty((Object[])annotationTypes)) {
            throw new IllegalArgumentException(message);
        }
        for (Class<?> clazz : annotationTypes) {
            if (Annotation.class.isAssignableFrom(clazz)) continue;
            throw new IllegalArgumentException("Array elements must be of type Annotation");
        }
    }

    public static class AnnotationDescriptor<T extends Annotation> {
        private final Class<?> rootDeclaringClass;
        private final Class<?> declaringClass;
        private final T annotation;

        AnnotationDescriptor(Class<?> rootDeclaringClass, T annotation) {
            this(rootDeclaringClass, rootDeclaringClass, annotation);
        }

        AnnotationDescriptor(Class<?> rootDeclaringClass, Class<?> declaringClass, T annotation) {
            Assert.notNull(rootDeclaringClass, (String)"'rootDeclaringClass' must not be null");
            Assert.notNull(declaringClass, (String)"'declaringClass' must not be null");
            Assert.notNull(annotation, (String)"Annotation must not be null");
            this.rootDeclaringClass = rootDeclaringClass;
            this.declaringClass = declaringClass;
            Annotation mergedAnnotation = AnnotatedElementUtils.findMergedAnnotation(rootDeclaringClass, annotation.annotationType());
            Assert.state((mergedAnnotation != null ? 1 : 0) != 0, () -> "Failed to find merged annotation for " + annotation);
            this.annotation = mergedAnnotation;
        }

        public Class<?> getRootDeclaringClass() {
            return this.rootDeclaringClass;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        Class<T> getAnnotationType() {
            return this.annotation.annotationType();
        }

        @Nullable
        public AnnotationDescriptor<T> next() {
            AnnotationDescriptor<T> descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(this.getRootDeclaringClass().getSuperclass(), this.getAnnotationType());
            if (descriptor == null && TestContextAnnotationUtils.searchEnclosingClass(this.getRootDeclaringClass())) {
                descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(this.getRootDeclaringClass().getEnclosingClass(), this.getAnnotationType());
            }
            return descriptor;
        }

        public Set<T> findAllLocalMergedAnnotations() {
            MergedAnnotations.SearchStrategy searchStrategy = MergedAnnotations.SearchStrategy.TYPE_HIERARCHY;
            return (Set)MergedAnnotations.from(this.getRootDeclaringClass(), (MergedAnnotations.SearchStrategy)searchStrategy, (RepeatableContainers)RepeatableContainers.none()).stream(this.getAnnotationType()).filter(MergedAnnotationPredicates.firstRunOf(MergedAnnotation::getAggregateIndex)).collect(MergedAnnotationCollectors.toAnnotationSet());
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("rootDeclaringClass", (Object)this.rootDeclaringClass.getName()).append("declaringClass", (Object)this.declaringClass.getName()).append("annotation", this.annotation).toString();
        }
    }

    public static class UntypedAnnotationDescriptor
    extends AnnotationDescriptor<Annotation> {
        private final Class<? extends Annotation>[] annotationTypes;

        UntypedAnnotationDescriptor(Class<?> rootDeclaringClass, Annotation annotation, Class<? extends Annotation>[] annotationTypes) {
            this(rootDeclaringClass, rootDeclaringClass, annotation, annotationTypes);
        }

        UntypedAnnotationDescriptor(Class<?> rootDeclaringClass, Class<?> declaringClass, Annotation annotation, Class<? extends Annotation>[] annotationTypes) {
            super(rootDeclaringClass, declaringClass, annotation);
            this.annotationTypes = annotationTypes;
        }

        @Nullable
        public UntypedAnnotationDescriptor next() {
            UntypedAnnotationDescriptor descriptor = TestContextAnnotationUtils.findAnnotationDescriptorForTypes(this.getRootDeclaringClass().getSuperclass(), this.annotationTypes);
            if (descriptor == null && TestContextAnnotationUtils.searchEnclosingClass(this.getRootDeclaringClass())) {
                descriptor = TestContextAnnotationUtils.findAnnotationDescriptorForTypes(this.getRootDeclaringClass().getEnclosingClass(), this.annotationTypes);
            }
            return descriptor;
        }

        @Override
        public Set<Annotation> findAllLocalMergedAnnotations() {
            throw new UnsupportedOperationException("findAllLocalMergedAnnotations() is unsupported in UntypedAnnotationDescriptor");
        }
    }
}

