/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Mono;

public class ExchangeResult {
    private static final Log logger = LogFactory.getLog(ExchangeResult.class);
    private static final List<MediaType> PRINTABLE_MEDIA_TYPES = List.of(MediaType.parseMediaType((String)"application/*+json"), MediaType.APPLICATION_XML, MediaType.parseMediaType((String)"text/*"), MediaType.APPLICATION_FORM_URLENCODED);
    private final ClientHttpRequest request;
    private final ClientHttpResponse response;
    private final Mono<byte[]> requestBody;
    private final Mono<byte[]> responseBody;
    private final Duration timeout;
    @Nullable
    private final String uriTemplate;
    @Nullable
    private final Object mockServerResult;
    private boolean diagnosticsLogged;

    ExchangeResult(ClientHttpRequest request2, ClientHttpResponse response, Mono<byte[]> requestBody, Mono<byte[]> responseBody, Duration timeout, @Nullable String uriTemplate, @Nullable Object serverResult) {
        Assert.notNull((Object)request2, (String)"ClientHttpRequest is required");
        Assert.notNull((Object)response, (String)"ClientHttpResponse is required");
        Assert.notNull(requestBody, (String)"'requestBody' is required");
        Assert.notNull(responseBody, (String)"'responseBody' is required");
        this.request = request2;
        this.response = response;
        this.requestBody = requestBody;
        this.responseBody = responseBody;
        this.timeout = timeout;
        this.uriTemplate = uriTemplate;
        this.mockServerResult = serverResult;
    }

    ExchangeResult(ExchangeResult other) {
        this.request = other.request;
        this.response = other.response;
        this.requestBody = other.requestBody;
        this.responseBody = other.responseBody;
        this.timeout = other.timeout;
        this.uriTemplate = other.uriTemplate;
        this.mockServerResult = other.mockServerResult;
        this.diagnosticsLogged = other.diagnosticsLogged;
    }

    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    public URI getUrl() {
        return this.request.getURI();
    }

    @Nullable
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public HttpHeaders getRequestHeaders() {
        return this.request.getHeaders();
    }

    @Nullable
    public byte[] getRequestBodyContent() {
        return (byte[])this.requestBody.block(this.timeout);
    }

    public HttpStatusCode getStatus() {
        return this.response.getStatusCode();
    }

    @Deprecated
    public int getRawStatusCode() {
        return this.response.getRawStatusCode();
    }

    public HttpHeaders getResponseHeaders() {
        return this.response.getHeaders();
    }

    public MultiValueMap<String, ResponseCookie> getResponseCookies() {
        return this.response.getCookies();
    }

    @Nullable
    public byte[] getResponseBodyContent() {
        return (byte[])this.responseBody.block(this.timeout);
    }

    @Nullable
    public Object getMockServerResult() {
        return this.mockServerResult;
    }

    public void assertWithDiagnostics(Runnable assertion) {
        try {
            assertion.run();
        }
        catch (AssertionError ex) {
            if (!this.diagnosticsLogged && logger.isErrorEnabled()) {
                this.diagnosticsLogged = true;
                logger.error((Object)("Request details for assertion failure:\n" + this));
            }
            throw ex;
        }
    }

    public String toString() {
        return "\n> " + this.getMethod() + " " + this.getUrl() + "\n> " + this.formatHeaders(this.getRequestHeaders(), "\n> ") + "\n\n" + this.formatBody(this.getRequestHeaders().getContentType(), this.requestBody) + "\n\n< " + this.getStatus() + " " + ExchangeResult.getReasonPhrase(this.getStatus()) + "\n< " + this.formatHeaders(this.getResponseHeaders(), "\n< ") + "\n\n" + this.formatBody(this.getResponseHeaders().getContentType(), this.responseBody) + "\n" + this.formatMockServerResult();
    }

    private static String getReasonPhrase(HttpStatusCode statusCode) {
        if (statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            return status.getReasonPhrase();
        }
        return "";
    }

    private String formatHeaders(HttpHeaders headers, String delimiter) {
        return headers.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + entry.getValue()).collect(Collectors.joining(delimiter));
    }

    @Nullable
    private String formatBody(@Nullable MediaType contentType, Mono<byte[]> body2) {
        return (String)body2.map(bytes -> {
            if (contentType == null) {
                return ((byte[])bytes).length + " bytes of content (unknown content-type).";
            }
            Charset charset = contentType.getCharset();
            if (charset != null) {
                return new String((byte[])bytes, charset);
            }
            if (PRINTABLE_MEDIA_TYPES.stream().anyMatch(arg_0 -> ((MediaType)contentType).isCompatibleWith(arg_0))) {
                return new String((byte[])bytes, StandardCharsets.UTF_8);
            }
            return ((byte[])bytes).length + " bytes of content.";
        }).defaultIfEmpty((Object)"No content").onErrorResume(ex -> Mono.just((Object)("Failed to obtain content: " + ex.getMessage()))).block(this.timeout);
    }

    private String formatMockServerResult() {
        return this.mockServerResult != null ? "\n======================  MockMvc (Server) ===============================\n" + this.mockServerResult + "\n" : "";
    }
}

