/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.ResolvableType;
import org.springframework.test.context.bean.override.BeanOverrideRegistrar;
import org.springframework.test.context.bean.override.OverrideMetadata;
import org.springframework.util.StringUtils;

class BeanOverrideBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private final BeanOverrideRegistrar overrideRegistrar;

    public BeanOverrideBeanFactoryPostProcessor(BeanOverrideRegistrar overrideRegistrar) {
        this.overrideRegistrar = overrideRegistrar;
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof BeanDefinitionRegistry)) {
            throw new IllegalStateException("Cannot process bean override with a BeanFactory that doesn't implement BeanDefinitionRegistry: " + beanFactory.getClass());
        }
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        this.postProcessWithRegistry(beanFactory, registry);
    }

    private void postProcessWithRegistry(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry) {
        for (OverrideMetadata metadata : this.overrideRegistrar.getOverrideMetadata()) {
            this.registerBeanOverride(beanFactory, registry, metadata);
        }
    }

    protected void copyBeanDefinitionDetails(BeanDefinition from, RootBeanDefinition to) {
        to.setPrimary(from.isPrimary());
        to.setFallback(from.isFallback());
        to.setScope(from.getScope());
    }

    private void registerBeanOverride(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, OverrideMetadata overrideMetadata) {
        switch (overrideMetadata.getStrategy()) {
            case REPLACE_DEFINITION: {
                this.registerReplaceDefinition(beanFactory, registry, overrideMetadata, true);
                break;
            }
            case REPLACE_OR_CREATE_DEFINITION: {
                this.registerReplaceDefinition(beanFactory, registry, overrideMetadata, false);
                break;
            }
            case WRAP_BEAN: {
                this.registerWrapBean(beanFactory, overrideMetadata);
            }
        }
    }

    private void registerReplaceDefinition(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, OverrideMetadata overrideMetadata, boolean enforceExistingDefinition) {
        RootBeanDefinition beanDefinition = this.createBeanDefinition(overrideMetadata);
        String beanName = overrideMetadata.getBeanName();
        BeanDefinition existingBeanDefinition = null;
        if (beanName == null) {
            candidates = this.getExistingBeanNamesByType(beanFactory, overrideMetadata, true);
            if (candidates.size() != 1) {
                Field f = overrideMetadata.getField();
                throw new IllegalStateException("Unable to select a bean definition to override, " + candidates.size() + " bean definitions found of type " + overrideMetadata.getBeanType() + " (as required by annotated field '" + f.getDeclaringClass().getSimpleName() + "." + f.getName() + "')");
            }
            beanName = candidates.iterator().next();
            existingBeanDefinition = beanFactory.getBeanDefinition(beanName);
        } else {
            candidates = this.getExistingBeanNamesByType(beanFactory, overrideMetadata, false);
            if (candidates.contains(beanName)) {
                existingBeanDefinition = beanFactory.getBeanDefinition(beanName);
            } else if (enforceExistingDefinition) {
                throw new IllegalStateException("Unable to override bean '" + beanName + "'; there is no bean definition to replace with that name of type " + overrideMetadata.getBeanType());
            }
        }
        if (existingBeanDefinition != null) {
            this.copyBeanDefinitionDetails(existingBeanDefinition, beanDefinition);
            registry.removeBeanDefinition(beanName);
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        Object override = overrideMetadata.createOverride(beanName, existingBeanDefinition, null);
        if (beanFactory.isSingleton(beanName)) {
            beanFactory.registerSingleton(beanName, override);
        }
        overrideMetadata.track(override, (SingletonBeanRegistry)beanFactory);
        this.overrideRegistrar.registerNameForMetadata(overrideMetadata, beanName);
    }

    private void registerWrapBean(ConfigurableListableBeanFactory beanFactory, OverrideMetadata metadata) {
        String beanName = metadata.getBeanName();
        if (beanName == null) {
            Set<String> candidateNames = this.getExistingBeanNamesByType(beanFactory, metadata, true);
            if (candidateNames.size() != 1) {
                Field f = metadata.getField();
                throw new IllegalStateException("Unable to select a bean to override by wrapping, " + candidateNames.size() + " bean instances found of type " + metadata.getBeanType() + " (as required by annotated field '" + f.getDeclaringClass().getSimpleName() + "." + f.getName() + "')");
            }
            beanName = candidateNames.iterator().next();
        } else {
            Set<String> candidates = this.getExistingBeanNamesByType(beanFactory, metadata, false);
            if (!candidates.contains(beanName)) {
                throw new IllegalStateException("Unable to override bean '" + beanName + "' by wrapping; there is no existing bean instance with that name of type " + metadata.getBeanType());
            }
        }
        this.overrideRegistrar.markWrapEarly(metadata, beanName);
        this.overrideRegistrar.registerNameForMetadata(metadata, beanName);
    }

    RootBeanDefinition createBeanDefinition(OverrideMetadata metadata) {
        RootBeanDefinition definition = new RootBeanDefinition();
        definition.setTargetType(metadata.getBeanType());
        definition.setQualifiedElement((AnnotatedElement)metadata.getField());
        return definition;
    }

    private Set<String> getExistingBeanNamesByType(ConfigurableListableBeanFactory beanFactory, OverrideMetadata metadata, boolean checkAutowiredCandidate) {
        ResolvableType resolvableType = metadata.getBeanType();
        LinkedHashSet<String> beans = new LinkedHashSet<String>(Arrays.asList(beanFactory.getBeanNamesForType(resolvableType, true, false)));
        Class type = resolvableType.resolve(Object.class);
        for (String beanName2 : beanFactory.getBeanNamesForType(FactoryBean.class, true, false)) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName2 = BeanFactoryUtils.transformedBeanName((String)beanName2));
            Object attribute = beanDefinition.getAttribute("factoryBeanObjectType");
            if (!resolvableType.equals(attribute) && !type.equals(attribute)) continue;
            beans.add(beanName2);
        }
        if (checkAutowiredCandidate) {
            DependencyDescriptor descriptor = new DependencyDescriptor(metadata.getField(), true);
            beans.removeIf(beanName -> ScopedProxyUtils.isScopedTarget((String)beanName) || !beanFactory.isAutowireCandidate(beanName, descriptor));
        } else {
            beans.removeIf(ScopedProxyUtils::isScopedTarget);
        }
        return beans;
    }

    static final class WrapEarlyBeanPostProcessor
    implements SmartInstantiationAwareBeanPostProcessor,
    PriorityOrdered {
        private final Map<String, Object> earlyReferences = new ConcurrentHashMap<String, Object>(16);
        private final BeanOverrideRegistrar overrideRegistrar;

        private WrapEarlyBeanPostProcessor(BeanOverrideRegistrar registrar) {
            this.overrideRegistrar = registrar;
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public Object getEarlyBeanReference(Object bean, String beanName) throws BeansException {
            if (bean instanceof FactoryBean) {
                return bean;
            }
            this.earlyReferences.put(this.getCacheKey(bean, beanName), bean);
            return this.overrideRegistrar.wrapIfNecessary(bean, beanName);
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof FactoryBean) {
                return bean;
            }
            if (this.earlyReferences.remove(this.getCacheKey(bean, beanName)) != bean) {
                return this.overrideRegistrar.wrapIfNecessary(bean, beanName);
            }
            return bean;
        }

        private String getCacheKey(Object bean, String beanName) {
            return StringUtils.hasLength((String)beanName) ? beanName : bean.getClass().getName();
        }
    }
}

