/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.bean.override.BeanOverrideBeanFactoryPostProcessor;
import org.springframework.test.context.bean.override.BeanOverrideRegistrar;

class BeanOverrideContextCustomizer
implements ContextCustomizer {
    private static final String REGISTRAR_BEAN_NAME = "org.springframework.test.context.bean.override.internalBeanOverrideRegistrar";
    private static final String INFRASTRUCTURE_BEAN_NAME = "org.springframework.test.context.bean.override.internalBeanOverridePostProcessor";
    private static final String EARLY_INFRASTRUCTURE_BEAN_NAME = "org.springframework.test.context.bean.override.internalWrapEarlyBeanPostProcessor";
    private final Set<Class<?>> detectedClasses;

    BeanOverrideContextCustomizer(Set<Class<?>> detectedClasses) {
        this.detectedClasses = detectedClasses;
    }

    static void registerInfrastructure(BeanDefinitionRegistry registry, Set<Class<?>> detectedClasses) {
        BeanOverrideContextCustomizer.addInfrastructureBeanDefinition(registry, BeanOverrideRegistrar.class, REGISTRAR_BEAN_NAME, constructorArgs -> constructorArgs.addIndexedArgumentValue(0, (Object)detectedClasses));
        RuntimeBeanReference registrarReference = new RuntimeBeanReference(REGISTRAR_BEAN_NAME);
        BeanOverrideContextCustomizer.addInfrastructureBeanDefinition(registry, BeanOverrideBeanFactoryPostProcessor.WrapEarlyBeanPostProcessor.class, EARLY_INFRASTRUCTURE_BEAN_NAME, constructorArgs -> constructorArgs.addIndexedArgumentValue(0, (Object)registrarReference));
        BeanOverrideContextCustomizer.addInfrastructureBeanDefinition(registry, BeanOverrideBeanFactoryPostProcessor.class, INFRASTRUCTURE_BEAN_NAME, constructorArgs -> constructorArgs.addIndexedArgumentValue(0, (Object)registrarReference));
    }

    private static void addInfrastructureBeanDefinition(BeanDefinitionRegistry registry, Class<?> clazz, String beanName, Consumer<ConstructorArgumentValues> constructorArgumentsConsumer) {
        if (!registry.containsBeanDefinition(beanName)) {
            RootBeanDefinition definition = new RootBeanDefinition(clazz);
            definition.setRole(2);
            ConstructorArgumentValues constructorArguments = definition.getConstructorArgumentValues();
            constructorArgumentsConsumer.accept(constructorArguments);
            registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
        }
    }

    @Override
    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        if (context instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)context;
            BeanOverrideContextCustomizer.registerInfrastructure(registry, this.detectedClasses);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BeanOverrideContextCustomizer other = (BeanOverrideContextCustomizer)obj;
        return this.detectedClasses.equals(other.detectedClasses);
    }

    public int hashCode() {
        return this.detectedClasses.hashCode();
    }
}

