/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.bean.override.BeanOverrideContextCustomizer;
import org.springframework.test.context.bean.override.BeanOverrideParsingUtils;

class BeanOverrideContextCustomizerFactory
implements ContextCustomizerFactory {
    BeanOverrideContextCustomizerFactory() {
    }

    @Override
    @Nullable
    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        LinkedHashSet detectedClasses = new LinkedHashSet();
        this.findClassesWithBeanOverride(testClass, detectedClasses);
        if (detectedClasses.isEmpty()) {
            return null;
        }
        return new BeanOverrideContextCustomizer(detectedClasses);
    }

    private void findClassesWithBeanOverride(Class<?> testClass, Set<Class<?>> detectedClasses) {
        if (BeanOverrideParsingUtils.hasBeanOverride(testClass)) {
            detectedClasses.add(testClass);
        }
        if (TestContextAnnotationUtils.searchEnclosingClass(testClass)) {
            this.findClassesWithBeanOverride(testClass.getEnclosingClass(), detectedClasses);
        }
    }
}

