/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.bean.override.BeanOverride;
import org.springframework.test.context.bean.override.BeanOverrideProcessor;
import org.springframework.test.context.bean.override.OverrideMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

abstract class BeanOverrideParsingUtils {
    BeanOverrideParsingUtils() {
    }

    static boolean hasBeanOverride(Class<?> clazz) {
        AtomicBoolean hasBeanOverride = new AtomicBoolean();
        ReflectionUtils.doWithFields(clazz, field -> {
            if (hasBeanOverride.get()) {
                return;
            }
            boolean present = MergedAnnotations.from((AnnotatedElement)field, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.DIRECT).isPresent(BeanOverride.class);
            hasBeanOverride.compareAndSet(false, present);
        });
        return hasBeanOverride.get();
    }

    static Set<OverrideMetadata> parse(Iterable<Class<?>> classes) {
        LinkedHashSet<OverrideMetadata> result = new LinkedHashSet<OverrideMetadata>();
        classes.forEach(c -> ReflectionUtils.doWithFields((Class)c, field -> BeanOverrideParsingUtils.parseField(field, c, result)));
        return result;
    }

    static Set<OverrideMetadata> parse(Class<?> clazz) {
        return BeanOverrideParsingUtils.parse(List.of(clazz));
    }

    private static void parseField(Field field, Class<?> testClass, Set<OverrideMetadata> metadataSet) {
        AtomicBoolean overrideAnnotationFound = new AtomicBoolean();
        MergedAnnotations.from((AnnotatedElement)field, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.DIRECT).stream(BeanOverride.class).forEach(mergedAnnotation -> {
            MergedAnnotation metaSource = mergedAnnotation.getMetaSource();
            Assert.state((metaSource != null ? 1 : 0) != 0, (String)"@BeanOverride annotation must be meta-present");
            BeanOverride beanOverride = (BeanOverride)mergedAnnotation.synthesize();
            BeanOverrideProcessor processor = (BeanOverrideProcessor)BeanUtils.instantiateClass(beanOverride.value());
            Annotation composedAnnotation = metaSource.synthesize();
            Assert.state((boolean)overrideAnnotationFound.compareAndSet(false, true), () -> "Multiple @BeanOverride annotations found on field: " + field);
            OverrideMetadata metadata = processor.createMetadata(composedAnnotation, testClass, field);
            metadataSet.add(metadata);
        });
    }
}

