/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverrideParsingUtils;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.OverrideMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class BeanOverrideRegistrar
implements BeanFactoryAware {
    private final Map<OverrideMetadata, String> beanNameRegistry = new HashMap<OverrideMetadata, String>();
    private final Map<String, OverrideMetadata> earlyOverrideMetadata = new HashMap<String, OverrideMetadata>();
    private final Set<OverrideMetadata> overrideMetadata;
    @Nullable
    private ConfigurableBeanFactory beanFactory;

    BeanOverrideRegistrar(Set<Class<?>> classesToParse) {
        this.overrideMetadata = BeanOverrideParsingUtils.parse(classesToParse);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalStateException("Cannot process bean override with a BeanFactory that doesn't implement ConfigurableBeanFactory: " + beanFactory.getClass());
        }
        ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
        this.beanFactory = cbf;
    }

    Set<OverrideMetadata> getOverrideMetadata() {
        return this.overrideMetadata;
    }

    Object wrapIfNecessary(Object bean, String beanName) throws BeansException {
        OverrideMetadata metadata = this.earlyOverrideMetadata.get(beanName);
        if (metadata != null && metadata.getStrategy() == BeanOverrideStrategy.WRAP_BEAN) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"ConfigurableBeanFactory must not be null");
            bean = metadata.createOverride(beanName, null, bean);
            metadata.track(bean, (SingletonBeanRegistry)this.beanFactory);
        }
        return bean;
    }

    void registerNameForMetadata(OverrideMetadata metadata, String beanName) {
        this.beanNameRegistry.put(metadata, beanName);
    }

    void markWrapEarly(OverrideMetadata metadata, String beanName) {
        this.earlyOverrideMetadata.put(beanName, metadata);
    }

    void inject(Object target, OverrideMetadata overrideMetadata) {
        String beanName = this.beanNameRegistry.get(overrideMetadata);
        Assert.state((boolean)StringUtils.hasLength((String)beanName), () -> "No bean found for OverrideMetadata: " + overrideMetadata);
        this.inject(overrideMetadata.getField(), target, beanName);
    }

    private void inject(Field field, Object target, String beanName) {
        try {
            ReflectionUtils.makeAccessible((Field)field);
            Object existingValue = ReflectionUtils.getField((Field)field, (Object)target);
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"ConfigurableBeanFactory must not be null");
            Object bean = this.beanFactory.getBean(beanName, field.getType());
            if (existingValue == bean) {
                return;
            }
            Assert.state((existingValue == null ? 1 : 0) != 0, () -> "The existing value '" + existingValue + "' of field '" + field + "' is not the same as the new value '" + bean + "'");
            ReflectionUtils.setField((Field)field, (Object)target, (Object)bean);
        }
        catch (Throwable ex) {
            throw new BeanCreationException("Could not inject field '" + field + "'", ex);
        }
    }
}

