/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.lang.reflect.Field;
import java.util.Objects;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;

public abstract class OverrideMetadata {
    private final Field field;
    private final ResolvableType beanType;
    private final BeanOverrideStrategy strategy;

    protected OverrideMetadata(Field field, ResolvableType beanType, BeanOverrideStrategy strategy) {
        this.field = field;
        this.beanType = beanType;
        this.strategy = strategy;
    }

    @Nullable
    protected String getBeanName() {
        return null;
    }

    public final ResolvableType getBeanType() {
        return this.beanType;
    }

    public final Field getField() {
        return this.field;
    }

    public final BeanOverrideStrategy getStrategy() {
        return this.strategy;
    }

    protected abstract Object createOverride(String var1, @Nullable BeanDefinition var2, @Nullable Object var3);

    protected void track(Object override, SingletonBeanRegistry trackingBeanRegistry) {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        OverrideMetadata that = (OverrideMetadata)obj;
        return Objects.equals((Object)this.strategy, (Object)that.strategy) && Objects.equals(this.field, that.field) && Objects.equals(this.beanType, that.beanType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.strategy, this.field, this.beanType});
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("strategy", (Object)this.strategy).append("field", (Object)this.field).append("beanType", (Object)this.beanType).toString();
    }
}

