/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.convention;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.bean.override.BeanOverrideProcessor;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.OverrideMetadata;
import org.springframework.test.context.bean.override.convention.TestBean;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class TestBeanOverrideProcessor
implements BeanOverrideProcessor {
    TestBeanOverrideProcessor() {
    }

    static Method findTestBeanFactoryMethod(Class<?> clazz, Class<?> methodReturnType, String ... methodNames) {
        Assert.isTrue((methodNames.length > 0 ? 1 : 0) != 0, (String)"At least one candidate method name is required");
        LinkedHashSet<String> supportedNames = new LinkedHashSet<String>(Arrays.asList(methodNames));
        List<Method> methods = Arrays.stream(ReflectionUtils.getAllDeclaredMethods(clazz)).filter(method -> Modifier.isStatic(method.getModifiers()) && supportedNames.contains(method.getName()) && methodReturnType.isAssignableFrom(method.getReturnType())).toList();
        if (methods.isEmpty() && TestContextAnnotationUtils.searchEnclosingClass(clazz)) {
            methods = Arrays.stream(ReflectionUtils.getAllDeclaredMethods(clazz.getEnclosingClass())).filter(method -> Modifier.isStatic(method.getModifiers()) && supportedNames.contains(method.getName()) && methodReturnType.isAssignableFrom(method.getReturnType())).toList();
        }
        Assert.state((!methods.isEmpty() ? 1 : 0) != 0, () -> "Failed to find a static test bean factory method in %s with return type %s whose name matches one of the supported candidates %s".formatted(clazz.getName(), methodReturnType.getName(), supportedNames));
        long nameCount = methods.stream().map(Method::getName).distinct().count();
        int methodCount = methods.size();
        Assert.state((nameCount == 1L ? 1 : 0) != 0, () -> "Found %d competing static test bean factory methods in %s with return type %s whose name matches one of the supported candidates %s".formatted(methodCount, clazz.getName(), methodReturnType.getName(), supportedNames));
        return methods.get(0);
    }

    @Override
    public TestBeanOverrideMetadata createMetadata(Annotation overrideAnnotation, Class<?> testClass, Field field) {
        String beanName;
        if (!(overrideAnnotation instanceof TestBean)) {
            throw new IllegalStateException(String.format("Invalid annotation passed to %s: expected @TestBean on field %s.%s", TestBeanOverrideProcessor.class.getSimpleName(), field.getDeclaringClass().getName(), field.getName()));
        }
        TestBean testBeanAnnotation = (TestBean)overrideAnnotation;
        Method explicitOverrideMethod = !testBeanAnnotation.methodName().isBlank() ? TestBeanOverrideProcessor.findTestBeanFactoryMethod(testClass, field.getType(), testBeanAnnotation.methodName()) : (!StringUtils.hasText((String)(beanName = testBeanAnnotation.name())) ? TestBeanOverrideProcessor.findTestBeanFactoryMethod(testClass, field.getType(), field.getName() + "TestOverride") : TestBeanOverrideProcessor.findTestBeanFactoryMethod(testClass, field.getType(), beanName + "TestOverride", field.getName() + "TestOverride"));
        return new TestBeanOverrideMetadata(field, explicitOverrideMethod, testBeanAnnotation, ResolvableType.forField((Field)field, testClass));
    }

    static final class TestBeanOverrideMetadata
    extends OverrideMetadata {
        private final Method overrideMethod;
        private final String beanName;

        public TestBeanOverrideMetadata(Field field, Method overrideMethod, TestBean overrideAnnotation, ResolvableType typeToOverride) {
            super(field, typeToOverride, BeanOverrideStrategy.REPLACE_DEFINITION);
            this.beanName = overrideAnnotation.name();
            this.overrideMethod = overrideMethod;
        }

        @Override
        @Nullable
        protected String getBeanName() {
            return StringUtils.hasText((String)this.beanName) ? this.beanName : super.getBeanName();
        }

        @Override
        protected Object createOverride(String beanName, @Nullable BeanDefinition existingBeanDefinition, @Nullable Object existingBeanInstance) {
            try {
                ReflectionUtils.makeAccessible((Method)this.overrideMethod);
                return this.overrideMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new IllegalArgumentException("Could not invoke bean overriding method " + this.overrideMethod.getName() + "; a static method with no formal parameters is expected", ex);
            }
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TestBeanOverrideMetadata that = (TestBeanOverrideMetadata)o;
            return Objects.equals(this.overrideMethod, that.overrideMethod) && Objects.equals(this.beanName, that.beanName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.overrideMethod, this.beanName);
        }
    }
}

