/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.mockito.Answers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.mockito.MockReset;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.context.bean.override.mockito.MockitoMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class MockitoBeanMetadata
extends MockitoMetadata {
    private final Set<Class<?>> extraInterfaces;
    private final Answers answer;
    private final boolean serializable;

    MockitoBeanMetadata(MockitoBean annotation, Field field, ResolvableType typeToMock) {
        this(annotation.name(), annotation.reset(), field, typeToMock, annotation.extraInterfaces(), annotation.answers(), annotation.serializable());
    }

    MockitoBeanMetadata(String name, MockReset reset, Field field, ResolvableType typeToMock, Class<?>[] extraInterfaces, @Nullable Answers answer, boolean serializable) {
        super(name, reset, false, field, typeToMock, BeanOverrideStrategy.REPLACE_OR_CREATE_DEFINITION);
        Assert.notNull((Object)typeToMock, (String)"TypeToMock must not be null");
        this.extraInterfaces = this.asClassSet(extraInterfaces);
        this.answer = answer != null ? answer : Answers.RETURNS_DEFAULTS;
        this.serializable = serializable;
    }

    @Override
    protected Object createOverride(String beanName, @Nullable BeanDefinition existingBeanDefinition, @Nullable Object existingBeanInstance) {
        return this.createMock(beanName);
    }

    private Set<Class<?>> asClassSet(@Nullable Class<?>[] classes) {
        LinkedHashSet classSet = new LinkedHashSet();
        if (classes != null) {
            classSet.addAll(Arrays.asList(classes));
        }
        return Collections.unmodifiableSet(classSet);
    }

    Set<Class<?>> getExtraInterfaces() {
        return this.extraInterfaces;
    }

    Answers getAnswer() {
        return this.answer;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MockitoBeanMetadata other = (MockitoBeanMetadata)obj;
        boolean result = super.equals(obj);
        result = result && ObjectUtils.nullSafeEquals(this.extraInterfaces, other.extraInterfaces);
        result = result && ObjectUtils.nullSafeEquals((Object)this.answer, (Object)other.answer);
        result = result && this.serializable == other.serializable;
        return result;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.extraInterfaces, this.answer, this.serializable);
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("beanName", (Object)this.getBeanName()).append("fieldType", (Object)this.getBeanType()).append("extraInterfaces", this.getExtraInterfaces()).append("answer", (Object)this.getAnswer()).append("serializable", this.isSerializable()).append("reset", (Object)this.getReset()).toString();
    }

    <T> T createMock(String name) {
        MockSettings settings = MockReset.withSettings(this.getReset());
        if (StringUtils.hasLength((String)name)) {
            settings.name(name);
        }
        if (!this.extraInterfaces.isEmpty()) {
            settings.extraInterfaces(ClassUtils.toClassArray(this.extraInterfaces));
        }
        settings.defaultAnswer((Answer)this.answer);
        if (this.serializable) {
            settings.serializable();
        }
        Class targetType = this.getBeanType().resolve();
        return (T)Mockito.mock((Class)targetType, (MockSettings)settings);
    }
}

