/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.springframework.core.ResolvableType;
import org.springframework.test.context.bean.override.BeanOverrideProcessor;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.test.context.bean.override.mockito.MockitoBeanMetadata;
import org.springframework.test.context.bean.override.mockito.MockitoMetadata;
import org.springframework.test.context.bean.override.mockito.MockitoSpyBean;
import org.springframework.test.context.bean.override.mockito.MockitoSpyBeanMetadata;

class MockitoBeanOverrideProcessor
implements BeanOverrideProcessor {
    MockitoBeanOverrideProcessor() {
    }

    @Override
    public MockitoMetadata createMetadata(Annotation overrideAnnotation, Class<?> testClass, Field field) {
        if (overrideAnnotation instanceof MockitoBean) {
            MockitoBean mockBean = (MockitoBean)overrideAnnotation;
            return new MockitoBeanMetadata(mockBean, field, ResolvableType.forField((Field)field, testClass));
        }
        if (overrideAnnotation instanceof MockitoSpyBean) {
            MockitoSpyBean spyBean = (MockitoSpyBean)overrideAnnotation;
            return new MockitoSpyBeanMetadata(spyBean, field, ResolvableType.forField((Field)field, testClass));
        }
        throw new IllegalStateException(String.format("Invalid annotation passed to MockitoBeanOverrideProcessor: expected @MockitoBean/@MockitoSpyBean on field %s.%s", field.getDeclaringClass().getName(), field.getName()));
    }
}

