/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.reflect.Field;
import java.util.Objects;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.OverrideMetadata;
import org.springframework.test.context.bean.override.mockito.MockReset;
import org.springframework.test.context.bean.override.mockito.MockitoBeans;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

abstract class MockitoMetadata
extends OverrideMetadata {
    protected final String name;
    private final MockReset reset;
    private final boolean proxyTargetAware;

    MockitoMetadata(String name, @Nullable MockReset reset, boolean proxyTargetAware, Field field, ResolvableType typeToOverride, BeanOverrideStrategy strategy) {
        super(field, typeToOverride, strategy);
        this.name = name;
        this.reset = reset != null ? reset : MockReset.AFTER;
        this.proxyTargetAware = proxyTargetAware;
    }

    @Override
    @Nullable
    protected String getBeanName() {
        return StringUtils.hasText((String)this.name) ? this.name : super.getBeanName();
    }

    @Override
    protected void track(Object mock, SingletonBeanRegistry trackingBeanRegistry) {
        MockitoBeans tracker = null;
        try {
            tracker = (MockitoBeans)trackingBeanRegistry.getSingleton(MockitoBeans.class.getName());
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (tracker == null) {
            tracker = new MockitoBeans();
            trackingBeanRegistry.registerSingleton(MockitoBeans.class.getName(), (Object)tracker);
        }
        tracker.add(mock);
    }

    MockReset getReset() {
        return this.reset;
    }

    boolean isProxyTargetAware() {
        return this.proxyTargetAware;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        MockitoMetadata other = (MockitoMetadata)obj;
        boolean result = super.equals(obj);
        result = result && ObjectUtils.nullSafeEquals((Object)this.name, (Object)other.name);
        result = result && ObjectUtils.nullSafeEquals((Object)((Object)this.reset), (Object)((Object)other.reset));
        result = result && ObjectUtils.nullSafeEquals((Object)this.proxyTargetAware, (Object)other.proxyTargetAware);
        return result;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.name, this.reset, this.proxyTargetAware});
    }
}

