/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.mockito.AdditionalAnswers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.listeners.VerificationStartedEvent;
import org.mockito.listeners.VerificationStartedListener;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.mockito.MockReset;
import org.springframework.test.context.bean.override.mockito.MockitoMetadata;
import org.springframework.test.context.bean.override.mockito.MockitoSpyBean;
import org.springframework.test.util.AopTestUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class MockitoSpyBeanMetadata
extends MockitoMetadata {
    MockitoSpyBeanMetadata(MockitoSpyBean spyAnnotation, Field field, ResolvableType typeToSpy) {
        this(spyAnnotation.name(), spyAnnotation.reset(), spyAnnotation.proxyTargetAware(), field, typeToSpy);
    }

    MockitoSpyBeanMetadata(String name, MockReset reset, boolean proxyTargetAware, Field field, ResolvableType typeToSpy) {
        super(name, reset, proxyTargetAware, field, typeToSpy, BeanOverrideStrategy.WRAP_BEAN);
        Assert.notNull((Object)typeToSpy, (String)"typeToSpy must not be null");
    }

    @Override
    protected Object createOverride(String beanName, @Nullable BeanDefinition existingBeanDefinition, @Nullable Object existingBeanInstance) {
        Assert.notNull((Object)existingBeanInstance, () -> "MockitoSpyBean requires an existing bean instance for bean " + beanName);
        return this.createSpy(beanName, existingBeanInstance);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MockitoSpyBeanMetadata that = (MockitoSpyBeanMetadata)obj;
        return super.equals(obj) && ObjectUtils.nullSafeEquals((Object)this.getBeanType(), (Object)that.getBeanType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBeanType());
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("beanName", (Object)this.getBeanName()).append("beanType", (Object)this.getBeanType()).append("reset", (Object)this.getReset()).toString();
    }

    <T> T createSpy(String name, Object instance) {
        Class<?> toSpy;
        Assert.notNull((Object)instance, (String)"Instance must not be null");
        Class resolvedTypeToOverride = this.getBeanType().resolve();
        Assert.notNull((Object)resolvedTypeToOverride, (String)"Failed to resolve type to override");
        Assert.isInstanceOf((Class)resolvedTypeToOverride, (Object)instance);
        if (Mockito.mockingDetails((Object)instance).isSpy()) {
            return (T)instance;
        }
        MockSettings settings = MockReset.withSettings(this.getReset());
        if (StringUtils.hasLength((String)name)) {
            settings.name(name);
        }
        if (this.isProxyTargetAware()) {
            settings.verificationStartedListeners(new VerificationStartedListener[]{new SpringAopBypassingVerificationStartedListener()});
        }
        if (Proxy.isProxyClass(instance.getClass())) {
            settings.defaultAnswer(AdditionalAnswers.delegatesTo((Object)instance));
            toSpy = this.getBeanType().toClass();
        } else {
            settings.defaultAnswer(Mockito.CALLS_REAL_METHODS);
            settings.spiedInstance(instance);
            toSpy = instance.getClass();
        }
        return (T)Mockito.mock(toSpy, (MockSettings)settings);
    }

    private static final class SpringAopBypassingVerificationStartedListener
    implements VerificationStartedListener {
        private SpringAopBypassingVerificationStartedListener() {
        }

        public void onVerificationStarted(VerificationStartedEvent event) {
            event.setMock(AopTestUtils.getUltimateTargetObject(event.getMock()));
        }
    }
}

