/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mockito.MockitoAnnotations;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class MockitoTestExecutionListener
extends AbstractTestExecutionListener {
    private static final String MOCKS_ATTRIBUTE_NAME = MockitoTestExecutionListener.class.getName() + ".mocks";
    static final boolean mockitoPresent = ClassUtils.isPresent((String)"org.mockito.MockSettings", (ClassLoader)MockitoTestExecutionListener.class.getClassLoader());

    @Override
    public final int getOrder() {
        return 1950;
    }

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        if (mockitoPresent) {
            this.closeMocks(testContext);
            this.initMocks(testContext);
        }
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (mockitoPresent && Boolean.TRUE.equals(testContext.getAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE))) {
            this.closeMocks(testContext);
            this.initMocks(testContext);
        }
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        if (mockitoPresent) {
            this.closeMocks(testContext);
        }
    }

    @Override
    public void afterTestClass(TestContext testContext) throws Exception {
        if (mockitoPresent) {
            this.closeMocks(testContext);
        }
    }

    private void initMocks(TestContext testContext) {
        if (this.hasMockitoAnnotations(testContext)) {
            Object testInstance = testContext.getTestInstance();
            testContext.setAttribute(MOCKS_ATTRIBUTE_NAME, MockitoAnnotations.openMocks((Object)testInstance));
        }
    }

    private void closeMocks(TestContext testContext) throws Exception {
        Object mocks = testContext.getAttribute(MOCKS_ATTRIBUTE_NAME);
        if (mocks instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)mocks;
            closeable.close();
        }
    }

    private boolean hasMockitoAnnotations(TestContext testContext) {
        MockitoAnnotationCollector collector = new MockitoAnnotationCollector();
        ReflectionUtils.doWithFields(testContext.getTestClass(), (ReflectionUtils.FieldCallback)collector);
        return collector.hasAnnotations();
    }

    private static final class MockitoAnnotationCollector
    implements ReflectionUtils.FieldCallback {
        private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();

        private MockitoAnnotationCollector() {
        }

        public void doWith(Field field) throws IllegalArgumentException {
            for (Annotation annotation : field.getAnnotations()) {
                if (!annotation.annotationType().getPackageName().startsWith("org.mockito")) continue;
                this.annotations.add(annotation);
            }
        }

        boolean hasAnnotations() {
            return !this.annotations.isEmpty();
        }
    }
}

