/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.weaving.LoadTimeWeaverAware;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.lang.Nullable;
import org.springframework.test.context.DynamicPropertySource;

class DynamicPropertySourceBeanInitializer
implements BeanFactoryAware,
InitializingBean,
LoadTimeWeaverAware {
    private static final Log logger = LogFactory.getLog(DynamicPropertySourceBeanInitializer.class);
    @Nullable
    private BeanFactory beanFactory;

    DynamicPropertySourceBeanInitializer() {
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        String[] stringArray = this.beanFactory;
        if (!(stringArray instanceof ListableBeanFactory)) {
            throw new IllegalStateException("BeanFactory must be set and must be a ListableBeanFactory");
        }
        ListableBeanFactory lbf = (ListableBeanFactory)stringArray;
        for (String name : lbf.getBeanNamesForAnnotation(DynamicPropertySource.class)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Eagerly initializing @DynamicPropertySource bean '%s'".formatted(name));
            }
            this.beanFactory.getBean(name);
        }
    }

    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
    }
}

