/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.json;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.Failures;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.comparator.JSONComparator;
import org.springframework.core.io.Resource;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.test.json.JsonLoader;
import org.springframework.test.json.JsonPathValueAssert;
import org.springframework.util.Assert;
import org.springframework.util.function.ThrowingBiFunction;

public abstract class AbstractJsonContentAssert<SELF extends AbstractJsonContentAssert<SELF>>
extends AbstractStringAssert<SELF> {
    private static final Failures failures = Failures.instance();
    @Nullable
    private final GenericHttpMessageConverter<Object> jsonMessageConverter;
    @Nullable
    private Class<?> resourceLoadClass;
    @Nullable
    private Charset charset;
    private JsonLoader jsonLoader;

    protected AbstractJsonContentAssert(@Nullable String json, @Nullable GenericHttpMessageConverter<Object> jsonMessageConverter, Class<?> selfType) {
        super(json, selfType);
        this.jsonMessageConverter = jsonMessageConverter;
        this.jsonLoader = new JsonLoader(null, null);
        this.as("JSON content", new Object[0]);
    }

    public JsonPathValueAssert extractingPath(String path) {
        Object value = new JsonPathValue(path).getValue();
        return new JsonPathValueAssert(value, path, this.jsonMessageConverter);
    }

    public SELF hasPathSatisfying(String path, Consumer<AssertProvider<JsonPathValueAssert>> valueRequirements) {
        Object value = new JsonPathValue(path).assertHasPath();
        JsonPathValueAssert valueAssert = new JsonPathValueAssert(value, path, this.jsonMessageConverter);
        valueRequirements.accept((AssertProvider<JsonPathValueAssert>)((AssertProvider)() -> valueAssert));
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    public SELF hasPath(String path) {
        new JsonPathValue(path).assertHasPath();
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    public SELF doesNotHavePath(String path) {
        new JsonPathValue(path).assertDoesNotHavePath();
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    public SELF isEqualTo(@Nullable CharSequence expected, JSONCompareMode compareMode) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public SELF isEqualTo(Resource expected, JSONCompareMode compareMode) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public SELF isEqualTo(@Nullable CharSequence expected, JSONComparator comparator) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public SELF isEqualTo(Resource expected, JSONComparator comparator) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertNotFailed(this.compare((CharSequence)expectedJson, comparator));
    }

    public SELF isLenientlyEqualTo(@Nullable CharSequence expected) {
        return this.isEqualTo(expected, JSONCompareMode.LENIENT);
    }

    public SELF isLenientlyEqualTo(Resource expected) {
        return this.isEqualTo(expected, JSONCompareMode.LENIENT);
    }

    public SELF isStrictlyEqualTo(@Nullable CharSequence expected) {
        return this.isEqualTo(expected, JSONCompareMode.STRICT);
    }

    public SELF isStrictlyEqualTo(Resource expected) {
        return this.isEqualTo(expected, JSONCompareMode.STRICT);
    }

    public SELF isNotEqualTo(@Nullable CharSequence expected, JSONCompareMode compareMode) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public SELF isNotEqualTo(Resource expected, JSONCompareMode compareMode) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, compareMode));
    }

    public SELF isNotEqualTo(@Nullable CharSequence expected, JSONComparator comparator) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public SELF isNotEqualTo(Resource expected, JSONComparator comparator) {
        String expectedJson = this.jsonLoader.getJson(expected);
        return this.assertNotPassed(this.compare((CharSequence)expectedJson, comparator));
    }

    public SELF isNotLenientlyEqualTo(@Nullable CharSequence expected) {
        return this.isNotEqualTo(expected, JSONCompareMode.LENIENT);
    }

    public SELF isNotLenientlyEqualTo(Resource expected) {
        return this.isNotEqualTo(expected, JSONCompareMode.LENIENT);
    }

    public SELF isNotStrictlyEqualTo(@Nullable CharSequence expected) {
        return this.isNotEqualTo(expected, JSONCompareMode.STRICT);
    }

    public SELF isNotStrictlyEqualTo(Resource expected) {
        return this.isNotEqualTo(expected, JSONCompareMode.STRICT);
    }

    public SELF withResourceLoadClass(@Nullable Class<?> resourceLoadClass) {
        this.resourceLoadClass = resourceLoadClass;
        this.jsonLoader = new JsonLoader(resourceLoadClass, this.charset);
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    public SELF withCharset(@Nullable Charset charset) {
        this.charset = charset;
        this.jsonLoader = new JsonLoader(this.resourceLoadClass, charset);
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    private JSONCompareResult compare(@Nullable CharSequence expectedJson, JSONCompareMode compareMode) {
        return this.compare((CharSequence)this.actual, expectedJson, (ThrowingBiFunction<String, String, JSONCompareResult>)((ThrowingBiFunction)(actualJsonString, expectedJsonString) -> JSONCompare.compareJSON((String)expectedJsonString, (String)actualJsonString, (JSONCompareMode)compareMode)));
    }

    private JSONCompareResult compare(@Nullable CharSequence expectedJson, JSONComparator comparator) {
        return this.compare((CharSequence)this.actual, expectedJson, (ThrowingBiFunction<String, String, JSONCompareResult>)((ThrowingBiFunction)(actualJsonString, expectedJsonString) -> JSONCompare.compareJSON((String)expectedJsonString, (String)actualJsonString, (JSONComparator)comparator)));
    }

    private JSONCompareResult compare(@Nullable CharSequence actualJson, @Nullable CharSequence expectedJson, ThrowingBiFunction<String, String, JSONCompareResult> comparator) {
        if (actualJson == null) {
            return this.compareForNull(expectedJson);
        }
        if (expectedJson == null) {
            return this.compareForNull(actualJson.toString());
        }
        try {
            return (JSONCompareResult)comparator.applyWithException((Object)actualJson.toString(), (Object)expectedJson.toString());
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)ex;
                throw runtimeException;
            }
            throw new IllegalStateException(ex);
        }
    }

    private JSONCompareResult compareForNull(@Nullable CharSequence expectedJson) {
        JSONCompareResult result = new JSONCompareResult();
        if (expectedJson != null) {
            result.fail("Expected null JSON");
        }
        return result;
    }

    private SELF assertNotFailed(JSONCompareResult result) {
        if (result.failed()) {
            this.failWithMessage("JSON comparison failure: %s", new Object[]{result.getMessage()});
        }
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    private SELF assertNotPassed(JSONCompareResult result) {
        if (result.passed()) {
            this.failWithMessage("JSON comparison failure: %s", new Object[]{result.getMessage()});
        }
        return (SELF)((Object)((AbstractJsonContentAssert)this.myself));
    }

    private AssertionError failure(BasicErrorMessageFactory errorMessageFactory) {
        throw failures.failure((AssertionInfo)this.info, (ErrorMessageFactory)errorMessageFactory);
    }

    private class JsonPathValue {
        private final String path;
        private final JsonPath jsonPath;
        private final String json;

        JsonPathValue(String path) {
            Assert.hasText((String)path, (String)"'path' must not be null or empty");
            AbstractJsonContentAssert.this.isNotNull();
            this.path = path;
            this.jsonPath = JsonPath.compile((String)this.path, (Predicate[])new Predicate[0]);
            this.json = (String)AbstractJsonContentAssert.this.actual;
        }

        @Nullable
        Object assertHasPath() {
            return this.getValue();
        }

        void assertDoesNotHavePath() {
            try {
                this.read();
                throw AbstractJsonContentAssert.this.failure(new JsonPathNotExpected(this.json, this.path));
            }
            catch (PathNotFoundException pathNotFoundException) {
                return;
            }
        }

        @Nullable
        Object getValue() {
            try {
                return this.read();
            }
            catch (PathNotFoundException ex) {
                throw AbstractJsonContentAssert.this.failure(new JsonPathNotFound(this.json, this.path));
            }
        }

        @Nullable
        private Object read() {
            return this.jsonPath.read(this.json);
        }

        static final class JsonPathNotExpected
        extends BasicErrorMessageFactory {
            private JsonPathNotExpected(String actual, String path) {
                super("%nExpecting:%n  %s%nNot to match JSON path:%n  %s%n", new Object[]{actual, path});
            }
        }

        static final class JsonPathNotFound
        extends BasicErrorMessageFactory {
            private JsonPathNotFound(String actual, String path) {
                super("%nExpecting:%n  %s%nTo match JSON path:%n  %s%n", new Object[]{actual, path});
            }
        }
    }
}

