/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileUpload;
import org.apache.tomcat.util.http.fileupload.RequestContext;
import org.apache.tomcat.util.http.fileupload.UploadContext;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.mock.http.MockHttpInputMessage;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.JsonExpectationsHelper;
import org.springframework.test.util.XmlExpectationsHelper;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.w3c.dom.Node;

public class ContentRequestMatchers {
    private static final Charset DEFAULT_MULTIPART_ENCODING = StandardCharsets.UTF_8;
    private final XmlExpectationsHelper xmlHelper = new XmlExpectationsHelper();
    private final JsonExpectationsHelper jsonHelper = new JsonExpectationsHelper();

    protected ContentRequestMatchers() {
    }

    public RequestMatcher contentType(String expectedContentType) {
        return this.contentType(MediaType.parseMediaType((String)expectedContentType));
    }

    public RequestMatcher contentType(MediaType expectedContentType) {
        return request2 -> {
            MediaType actualContentType = request2.getHeaders().getContentType();
            AssertionErrors.assertTrue("Content type not set", actualContentType != null);
            AssertionErrors.assertEquals("Content type", expectedContentType, actualContentType);
        };
    }

    public RequestMatcher contentTypeCompatibleWith(String contentType) {
        return this.contentTypeCompatibleWith(MediaType.parseMediaType((String)contentType));
    }

    public RequestMatcher contentTypeCompatibleWith(MediaType contentType) {
        return request2 -> {
            MediaType actualContentType = request2.getHeaders().getContentType();
            AssertionErrors.assertTrue("Content type not set", actualContentType != null);
            if (actualContentType != null) {
                AssertionErrors.assertTrue("Content type [" + actualContentType + "] is not compatible with [" + contentType + "]", actualContentType.isCompatibleWith(contentType));
            }
        };
    }

    public RequestMatcher string(Matcher<? super String> matcher) {
        return request2 -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
            MatcherAssert.assertThat((String)"Request content", (Object)mockRequest.getBodyAsString(), (Matcher)matcher);
        };
    }

    public RequestMatcher string(String expectedContent) {
        return request2 -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
            AssertionErrors.assertEquals("Request content", expectedContent, mockRequest.getBodyAsString());
        };
    }

    public RequestMatcher bytes(byte[] expectedContent) {
        return request2 -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
            AssertionErrors.assertEquals("Request content", expectedContent, mockRequest.getBodyAsBytes());
        };
    }

    public RequestMatcher formData(MultiValueMap<String, String> expected) {
        return this.formData(expected, true);
    }

    public RequestMatcher formDataContains(Map<String, String> expected) {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap(expected.size());
        expected.forEach((arg_0, arg_1) -> ((MultiValueMap)multiValueMap).add(arg_0, arg_1));
        return this.formData((MultiValueMap<String, String>)multiValueMap, false);
    }

    private RequestMatcher formData(MultiValueMap<String, String> expectedMap, boolean containsExactly) {
        return request2 -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
            MockHttpInputMessage message = new MockHttpInputMessage(mockRequest.getBodyAsBytes());
            message.getHeaders().putAll((Map)mockRequest.getHeaders());
            MultiValueMap actualMap = new FormHttpMessageConverter().read(null, (HttpInputMessage)message);
            if (containsExactly) {
                AssertionErrors.assertEquals("Form data", expectedMap, actualMap);
            } else {
                AssertionErrors.assertTrue("Form data " + actualMap, expectedMap.size() <= actualMap.size());
                for (Map.Entry entry : expectedMap.entrySet()) {
                    String name = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    AssertionErrors.assertTrue("No form parameter '" + name + "'", actualMap.get((Object)name) != null);
                    AssertionErrors.assertTrue("Parameter value count " + values.size(), values.size() <= ((List)actualMap.get((Object)name)).size());
                    for (int i = 0; i < values.size(); ++i) {
                        AssertionErrors.assertEquals("Form parameter", values.get(i), ((List)actualMap.get((Object)name)).get(i));
                    }
                }
            }
        };
    }

    public RequestMatcher multipartData(MultiValueMap<String, ?> expectedMap) {
        return this.multipartData(expectedMap, DEFAULT_MULTIPART_ENCODING, true);
    }

    public RequestMatcher multipartData(MultiValueMap<String, ?> expectedMap, Charset defaultCharset) {
        return this.multipartData(expectedMap, defaultCharset, true);
    }

    public RequestMatcher multipartDataContains(Map<String, ?> expectedMap) {
        LinkedMultiValueMap map = new LinkedMultiValueMap(expectedMap.size());
        expectedMap.forEach((arg_0, arg_1) -> ((MultiValueMap)map).add(arg_0, arg_1));
        return this.multipartData((MultiValueMap<String, ?>)map, DEFAULT_MULTIPART_ENCODING, false);
    }

    private RequestMatcher multipartData(MultiValueMap<String, ?> expectedMap, Charset defaultCharset, boolean containsExactly) {
        return request2 -> {
            MultiValueMap<String, ?> actualMap = MultipartHelper.parse((MockClientHttpRequest)request2, defaultCharset);
            if (containsExactly) {
                AssertionErrors.assertEquals("Multipart request content: " + actualMap, expectedMap.size(), actualMap.size());
            }
            for (Map.Entry entry : expectedMap.entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                AssertionErrors.assertTrue("No Multipart '" + name + "'", actualMap.get((Object)name) != null);
                AssertionErrors.assertTrue("Multipart value count " + values.size(), containsExactly ? values.size() == ((List)actualMap.get((Object)name)).size() : values.size() <= ((List)actualMap.get((Object)name)).size());
                for (int i = 0; i < values.size(); ++i) {
                    Object expected = values.get(i);
                    Object actual = ((List)actualMap.get((Object)name)).get(i);
                    if (expected instanceof Resource) {
                        Resource resource = (Resource)expected;
                        expected = StreamUtils.copyToByteArray((InputStream)resource.getInputStream());
                    }
                    if (expected instanceof byte[]) {
                        AssertionErrors.assertTrue("Multipart is not a file", actual instanceof byte[]);
                        AssertionErrors.assertEquals("Multipart content", expected, actual);
                        continue;
                    }
                    if (expected instanceof String) {
                        AssertionErrors.assertTrue("Multipart is not a String", actual instanceof String);
                        AssertionErrors.assertEquals("Multipart content", expected, actual);
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected multipart value: " + expected.getClass());
                }
            }
        };
    }

    public RequestMatcher xml(final String expectedXmlContent) {
        return new AbstractXmlRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws Exception {
                ContentRequestMatchers.this.xmlHelper.assertXmlEqual(expectedXmlContent, request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher node(final Matcher<? super Node> matcher) {
        return new AbstractXmlRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws Exception {
                ContentRequestMatchers.this.xmlHelper.assertNode(request2.getBodyAsString(), (Matcher<? super Node>)matcher);
            }
        };
    }

    public RequestMatcher source(final Matcher<? super Source> matcher) {
        return new AbstractXmlRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws Exception {
                ContentRequestMatchers.this.xmlHelper.assertSource(request2.getBodyAsString(), (Matcher<? super Source>)matcher);
            }
        };
    }

    public RequestMatcher json(String expectedJsonContent) {
        return this.json(expectedJsonContent, false);
    }

    public RequestMatcher json(String expectedJsonContent, boolean strict) {
        return request2 -> {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
                this.jsonHelper.assertJsonEqual(expectedJsonContent, mockRequest.getBodyAsString(), strict);
            }
            catch (Exception ex) {
                throw new AssertionError("Failed to parse expected or actual JSON request content", ex);
            }
        };
    }

    private static class MultipartHelper {
        private MultipartHelper() {
        }

        public static MultiValueMap<String, ?> parse(final MockClientHttpRequest request2, Charset defaultCharset) {
            try {
                FileUpload fileUpload = new FileUpload();
                DiskFileItemFactory factory = new DiskFileItemFactory();
                factory.setDefaultCharset(defaultCharset.name());
                fileUpload.setFileItemFactory((FileItemFactory)factory);
                List fileItems = fileUpload.parseRequest((RequestContext)new UploadContext(){
                    private final byte[] body;
                    {
                        this.body = request2.getBodyAsBytes();
                    }

                    @Nullable
                    public String getCharacterEncoding() {
                        return request2.getHeaders().getFirst("Content-Encoding");
                    }

                    @Nullable
                    public String getContentType() {
                        return request2.getHeaders().getFirst("Content-Type");
                    }

                    public InputStream getInputStream() {
                        return new ByteArrayInputStream(this.body);
                    }

                    public long contentLength() {
                        return this.body.length;
                    }
                });
                LinkedMultiValueMap result = new LinkedMultiValueMap();
                for (FileItem fileItem : fileItems) {
                    result.add((Object)fileItem.getFieldName(), fileItem.isFormField() ? fileItem.getString() : (Object)fileItem.get());
                }
                return result;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to parse multipart request", ex);
            }
        }
    }

    private static abstract class AbstractXmlRequestMatcher
    implements RequestMatcher {
        private AbstractXmlRequestMatcher() {
        }

        @Override
        public final void match(ClientHttpRequest request2) throws IOException, AssertionError {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
                this.matchInternal(mockRequest);
            }
            catch (Exception ex) {
                throw new AssertionError("Failed to parse expected or actual XML request content", ex);
            }
        }

        protected abstract void matchInternal(MockClientHttpRequest var1) throws Exception;
    }
}

