/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.assertj;

import java.nio.charset.Charset;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ByteArrayAssert;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.json.AbstractJsonContentAssert;
import org.springframework.test.json.JsonContentAssert;
import org.springframework.test.web.UriAssert;
import org.springframework.test.web.servlet.assertj.AbstractHttpServletResponseAssert;

public abstract class AbstractMockHttpServletResponseAssert<SELF extends AbstractMockHttpServletResponseAssert<SELF, ACTUAL>, ACTUAL>
extends AbstractHttpServletResponseAssert<MockHttpServletResponse, SELF, ACTUAL> {
    @Nullable
    private final GenericHttpMessageConverter<Object> jsonMessageConverter;

    protected AbstractMockHttpServletResponseAssert(@Nullable GenericHttpMessageConverter<Object> jsonMessageConverter, ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
        this.jsonMessageConverter = jsonMessageConverter;
    }

    public AbstractStringAssert<?> bodyText() {
        return Assertions.assertThat((String)this.readBody());
    }

    public AbstractJsonContentAssert<?> bodyJson() {
        return new JsonContentAssert(this.readBody(), this.jsonMessageConverter);
    }

    private String readBody() {
        return new String(((MockHttpServletResponse)this.getResponse()).getContentAsByteArray(), Charset.forName(((MockHttpServletResponse)this.getResponse()).getCharacterEncoding()));
    }

    public AbstractByteArrayAssert<?> body() {
        return new ByteArrayAssert(((MockHttpServletResponse)this.getResponse()).getContentAsByteArray());
    }

    public UriAssert forwardedUrl() {
        return new UriAssert(((MockHttpServletResponse)this.getResponse()).getForwardedUrl(), "Forwarded URL");
    }

    public UriAssert redirectedUrl() {
        return new UriAssert(((MockHttpServletResponse)this.getResponse()).getRedirectedUrl(), "Redirected URL");
    }

    public SELF hasBodyTextEqualTo(String bodyText) {
        this.bodyText().isEqualTo(bodyText);
        return (SELF)((Object)((AbstractMockHttpServletResponseAssert)this.myself));
    }

    public SELF hasForwardedUrl(@Nullable String forwardedUrl) {
        this.forwardedUrl().isEqualTo(forwardedUrl);
        return (SELF)((Object)((AbstractMockHttpServletResponseAssert)this.myself));
    }

    public SELF hasRedirectedUrl(@Nullable String redirectedUrl) {
        this.redirectedUrl().isEqualTo(redirectedUrl);
        return (SELF)((Object)((AbstractMockHttpServletResponseAssert)this.myself));
    }
}

