/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.assertj;

import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.assertj.MvcTestResult;
import org.springframework.test.web.servlet.assertj.MvcTestResultAssert;

final class DefaultMvcTestResult
implements MvcTestResult {
    @Nullable
    private final MvcResult mvcResult;
    @Nullable
    private final Exception unresolvedException;
    @Nullable
    private final GenericHttpMessageConverter<Object> jsonMessageConverter;

    DefaultMvcTestResult(@Nullable MvcResult mvcResult, @Nullable Exception unresolvedException, @Nullable GenericHttpMessageConverter<Object> jsonMessageConverter) {
        this.mvcResult = mvcResult;
        this.unresolvedException = unresolvedException;
        this.jsonMessageConverter = jsonMessageConverter;
    }

    @Override
    public MvcResult getMvcResult() {
        if (this.mvcResult == null) {
            throw new IllegalStateException("Request failed with unresolved exception " + this.unresolvedException);
        }
        return this.mvcResult;
    }

    @Override
    @Nullable
    public Exception getUnresolvedException() {
        return this.unresolvedException;
    }

    @Nullable
    public Exception getResolvedException() {
        return this.getMvcResult().getResolvedException();
    }

    public MvcTestResultAssert assertThat() {
        return new MvcTestResultAssert(this, this.jsonMessageConverter);
    }
}

