/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.assertj;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.assertj.DefaultMvcTestResult;
import org.springframework.test.web.servlet.assertj.MvcTestResult;
import org.springframework.test.web.servlet.setup.AbstractMockMvcBuilder;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public final class MockMvcTester {
    private static final MediaType JSON = MediaType.APPLICATION_JSON;
    private final MockMvc mockMvc;
    @Nullable
    private final GenericHttpMessageConverter<Object> jsonMessageConverter;

    private MockMvcTester(MockMvc mockMvc, @Nullable GenericHttpMessageConverter<Object> jsonMessageConverter) {
        Assert.notNull((Object)mockMvc, (String)"mockMVC should not be null");
        this.mockMvc = mockMvc;
        this.jsonMessageConverter = jsonMessageConverter;
    }

    public static MockMvcTester create(MockMvc mockMvc) {
        return new MockMvcTester(mockMvc, null);
    }

    public static MockMvcTester from(WebApplicationContext applicationContext, Function<DefaultMockMvcBuilder, MockMvc> customizations) {
        DefaultMockMvcBuilder builder = MockMvcBuilders.webAppContextSetup(applicationContext);
        MockMvc mockMvc = customizations.apply(builder);
        return MockMvcTester.create(mockMvc);
    }

    public static MockMvcTester from(WebApplicationContext applicationContext) {
        return MockMvcTester.from(applicationContext, AbstractMockMvcBuilder::build);
    }

    public static MockMvcTester of(Collection<?> controllers, Function<StandaloneMockMvcBuilder, MockMvc> customizations) {
        StandaloneMockMvcBuilder builder = MockMvcBuilders.standaloneSetup(controllers.toArray());
        return MockMvcTester.create(customizations.apply(builder));
    }

    public static MockMvcTester of(Object ... controllers) {
        return MockMvcTester.of(Arrays.asList(controllers), AbstractMockMvcBuilder::build);
    }

    public MockMvcTester withHttpMessageConverters(Iterable<HttpMessageConverter<?>> httpMessageConverters) {
        return new MockMvcTester(this.mockMvc, this.findJsonMessageConverter(httpMessageConverters));
    }

    public MvcTestResult perform(RequestBuilder requestBuilder) {
        Object result = this.getMvcResultOrFailure(requestBuilder);
        if (result instanceof MvcResult) {
            MvcResult mvcResult = (MvcResult)result;
            return new DefaultMvcTestResult(mvcResult, null, this.jsonMessageConverter);
        }
        return new DefaultMvcTestResult(null, (Exception)result, this.jsonMessageConverter);
    }

    private Object getMvcResultOrFailure(RequestBuilder requestBuilder) {
        try {
            return this.mockMvc.perform(requestBuilder).andReturn();
        }
        catch (Exception ex) {
            return ex;
        }
    }

    @Nullable
    private GenericHttpMessageConverter<Object> findJsonMessageConverter(Iterable<HttpMessageConverter<?>> messageConverters) {
        return StreamSupport.stream(messageConverters.spliterator(), false).filter(GenericHttpMessageConverter.class::isInstance).map(GenericHttpMessageConverter.class::cast).filter(converter -> converter.canWrite(null, Map.class, JSON)).filter(converter -> converter.canRead(Map.class, JSON)).findFirst().orElse(null);
    }
}

