/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.support;

import java.util.List;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.LoggingCodecSupport;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.ServerSentEventHttpMessageWriter;
import org.springframework.http.codec.multipart.DefaultMultipartMessageReader;
import org.springframework.http.codec.multipart.MultipartHttpMessageReader;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.codec.support.BaseDefaultCodecs;
import org.springframework.lang.Nullable;

class ServerDefaultCodecsImpl
extends BaseDefaultCodecs
implements ServerCodecConfigurer.ServerDefaultCodecs {
    @Nullable
    private Encoder<?> sseEncoder;
    @Nullable
    private HttpMessageReader<Part> multipartReader;

    ServerDefaultCodecsImpl() {
    }

    @Override
    public void serverSentEventEncoder(Encoder<?> encoder) {
        this.sseEncoder = encoder;
    }

    @Override
    public void multipartReader(HttpMessageReader<Part> multipartReader) {
        this.multipartReader = multipartReader;
    }

    @Override
    protected void extendTypedReaders(List<HttpMessageReader<?>> typedReaders) {
        HttpMessageReader<Part> partReader = this.getMultipartReader();
        boolean logRequestDetails = this.isEnableLoggingRequestDetails();
        if (partReader instanceof LoggingCodecSupport) {
            ((LoggingCodecSupport)((Object)partReader)).setEnableLoggingRequestDetails(logRequestDetails);
        }
        typedReaders.add(partReader);
        MultipartHttpMessageReader reader = new MultipartHttpMessageReader(partReader);
        reader.setEnableLoggingRequestDetails(logRequestDetails);
        typedReaders.add(reader);
    }

    private HttpMessageReader<Part> getMultipartReader() {
        return this.multipartReader != null ? this.multipartReader : new DefaultMultipartMessageReader();
    }

    @Override
    protected void extendObjectWriters(List<HttpMessageWriter<?>> objectWriters) {
        objectWriters.add(new ServerSentEventHttpMessageWriter(this.getSseEncoder()));
    }

    @Nullable
    private Encoder<?> getSseEncoder() {
        return this.sseEncoder != null ? this.sseEncoder : (jackson2Present ? this.getJackson2JsonEncoder() : null);
    }
}

