/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.lang.reflect.Type;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;

public class RequestBodyArgumentResolver
implements HttpServiceArgumentResolver {
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;

    public RequestBodyArgumentResolver(ReactiveAdapterRegistry reactiveAdapterRegistry) {
        Assert.notNull((Object)reactiveAdapterRegistry, (String)"ReactiveAdapterRegistry is required");
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
    }

    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        RequestBody annot = (RequestBody)parameter.getParameterAnnotation(RequestBody.class);
        if (annot == null) {
            return false;
        }
        if (argument != null) {
            ReactiveAdapter reactiveAdapter = this.reactiveAdapterRegistry.getAdapter(parameter.getParameterType());
            if (reactiveAdapter != null) {
                this.setBody(argument, parameter, reactiveAdapter, requestValues);
            } else {
                requestValues.setBodyValue(argument);
            }
        }
        return true;
    }

    private <E> void setBody(Object argument, MethodParameter parameter, ReactiveAdapter reactiveAdapter, HttpRequestValues.Builder requestValues) {
        String message = "Async type for @RequestBody should produce value(s)";
        Assert.isTrue((!reactiveAdapter.isNoValue() ? 1 : 0) != 0, (String)message);
        parameter = parameter.nested();
        Class elementClass = parameter.getNestedParameterType();
        Assert.isTrue((elementClass != Void.class ? 1 : 0) != 0, (String)message);
        ParameterizedTypeReference typeRef = ParameterizedTypeReference.forType((Type)parameter.getNestedGenericParameterType());
        Publisher publisher = reactiveAdapter.toPublisher(argument);
        requestValues.setBody(publisher, typeRef);
    }
}

