/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.observation.ClientHttpObservation;
import org.springframework.http.client.observation.ClientHttpObservationContext;
import org.springframework.http.client.observation.ClientHttpObservationConvention;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DefaultClientHttpObservationConvention
implements ClientHttpObservationConvention {
    private static final String DEFAULT_NAME = "http.client.requests";
    private static final KeyValue URI_NONE = KeyValue.of((KeyName)ClientHttpObservation.LowCardinalityKeyNames.URI, (String)"none");
    private static final KeyValue METHOD_NONE = KeyValue.of((KeyName)ClientHttpObservation.LowCardinalityKeyNames.METHOD, (String)"none");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of((KeyName)ClientHttpObservation.LowCardinalityKeyNames.EXCEPTION, (String)"none");
    private static final KeyValue OUTCOME_UNKNOWN = KeyValue.of((KeyName)ClientHttpObservation.LowCardinalityKeyNames.OUTCOME, (String)"UNKNOWN");
    private static final KeyValue URI_EXPANDED_NONE = KeyValue.of((KeyName)ClientHttpObservation.HighCardinalityKeyNames.URI_EXPANDED, (String)"none");
    private final String name;

    public DefaultClientHttpObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultClientHttpObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public KeyValues getLowCardinalityKeyValues(ClientHttpObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.uri(context), this.method(context), this.status(context), this.exception(context), DefaultClientHttpObservationConvention.outcome(context)});
    }

    protected KeyValue uri(ClientHttpObservationContext context) {
        if (context.getUriTemplate() != null) {
            return KeyValue.of((KeyName)ClientHttpObservation.LowCardinalityKeyNames.URI, (String)context.getUriTemplate());
        }
        return URI_NONE;
    }

    protected KeyValue method(ClientHttpObservationContext context) {
        if (context.getCarrier() != null) {
            return KeyValue.of((KeyName)ClientHttpObservation.LowCardinalityKeyNames.METHOD, (String)((ClientHttpRequest)context.getCarrier()).getMethod().name());
        }
        return METHOD_NONE;
    }

    protected KeyValue status(ClientHttpObservationContext context) {
        return KeyValue.of((KeyName)ClientHttpObservation.LowCardinalityKeyNames.STATUS, (String)this.getStatusMessage((ClientHttpResponse)context.getResponse()));
    }

    private String getStatusMessage(@Nullable ClientHttpResponse response) {
        try {
            if (response == null) {
                return "CLIENT_ERROR";
            }
            return String.valueOf(response.getStatusCode().value());
        }
        catch (IOException ex) {
            return "IO_ERROR";
        }
    }

    protected KeyValue exception(ClientHttpObservationContext context) {
        return context.getError().map(exception -> {
            String simpleName = exception.getClass().getSimpleName();
            return KeyValue.of((KeyName)ClientHttpObservation.LowCardinalityKeyNames.EXCEPTION, (String)(StringUtils.hasText((String)simpleName) ? simpleName : exception.getClass().getName()));
        }).orElse(EXCEPTION_NONE);
    }

    protected static KeyValue outcome(ClientHttpObservationContext context) {
        try {
            HttpStatus status;
            if (context.getResponse() != null && (status = HttpStatus.resolve(((ClientHttpResponse)context.getResponse()).getStatusCode().value())) != null) {
                return KeyValue.of((KeyName)ClientHttpObservation.LowCardinalityKeyNames.OUTCOME, (String)status.series().name());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return OUTCOME_UNKNOWN;
    }

    public KeyValues getHighCardinalityKeyValues(ClientHttpObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.requestUri(context), this.clientName(context)});
    }

    protected KeyValue requestUri(ClientHttpObservationContext context) {
        if (context.getCarrier() != null) {
            return KeyValue.of((KeyName)ClientHttpObservation.HighCardinalityKeyNames.URI_EXPANDED, (String)((ClientHttpRequest)context.getCarrier()).getURI().toASCIIString());
        }
        return URI_EXPANDED_NONE;
    }

    protected KeyValue clientName(ClientHttpObservationContext context) {
        String host = "none";
        if (context.getCarrier() != null && ((ClientHttpRequest)context.getCarrier()).getURI().getHost() != null) {
            host = ((ClientHttpRequest)context.getCarrier()).getURI().getHost();
        }
        return KeyValue.of((KeyName)ClientHttpObservation.HighCardinalityKeyNames.CLIENT_NAME, (String)host);
    }
}

