/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.Collection;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.DefaultRenderingResponseBuilder;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

public interface RenderingResponse
extends ServerResponse {
    public String name();

    public Map<String, Object> model();

    public static Builder from(RenderingResponse other) {
        Assert.notNull((Object)other, (String)"'other' must not be null");
        DefaultRenderingResponseBuilder builder = new DefaultRenderingResponseBuilder(other.name());
        builder.status(other.statusCode());
        builder.headers(other.headers());
        builder.modelAttributes(other.model());
        return builder;
    }

    public static Builder create(String name) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        return new DefaultRenderingResponseBuilder(name);
    }

    public static interface Builder {
        public Builder modelAttribute(Object var1);

        public Builder modelAttribute(String var1, @Nullable Object var2);

        public Builder modelAttributes(Object ... var1);

        public Builder modelAttributes(Collection<?> var1);

        public Builder modelAttributes(Map<String, ?> var1);

        public Builder header(String var1, String ... var2);

        public Builder headers(HttpHeaders var1);

        public Builder status(HttpStatus var1);

        public Mono<RenderingResponse> build();
    }
}

