/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.session;

import java.util.Map;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;
import org.springframework.web.socket.sockjs.frame.SockJsFrame;
import org.springframework.web.socket.sockjs.frame.SockJsMessageCodec;
import org.springframework.web.socket.sockjs.transport.SockJsServiceConfig;
import org.springframework.web.socket.sockjs.transport.session.AbstractHttpSockJsSession;

public class StreamingSockJsSession
extends AbstractHttpSockJsSession {
    private int byteCount;

    public StreamingSockJsSession(String sessionId, SockJsServiceConfig config, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        super(sessionId, config, wsHandler, attributes);
    }

    @Override
    protected boolean isStreaming() {
        return true;
    }

    @Override
    protected void flushCache() throws SockJsTransportFailureException {
        while (!this.getMessageCache().isEmpty()) {
            String message = this.getMessageCache().poll();
            SockJsMessageCodec messageCodec = this.getSockJsServiceConfig().getMessageCodec();
            SockJsFrame frame = SockJsFrame.messageFrame(messageCodec, message);
            this.writeFrame(frame);
            this.byteCount += frame.getContentBytes().length + 1;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(this.byteCount + " bytes written so far, " + this.getMessageCache().size() + " more messages not flushed"));
            }
            if (this.byteCount < this.getSockJsServiceConfig().getStreamBytesLimit()) continue;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Streamed bytes limit reached. Recycling current request");
            }
            this.resetRequest();
            this.byteCount = 0;
            break;
        }
        this.scheduleHeartbeat();
    }
}

