/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;

public abstract class NumberUtils {
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public static Number convertNumberToTargetClass(Number number, Class targetClass) throws IllegalArgumentException {
        if (targetClass.isInstance(number)) {
            return number;
        }
        if (targetClass.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte(number.byteValue());
        }
        if (targetClass.equals(class$java$lang$Short == null ? (class$java$lang$Short = NumberUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short(number.shortValue());
        }
        if (targetClass.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(number.intValue());
        }
        if (targetClass.equals(class$java$lang$Long == null ? (class$java$lang$Long = NumberUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(number.longValue());
        }
        if (targetClass.equals(class$java$lang$Float == null ? (class$java$lang$Float = NumberUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(number.floatValue());
        }
        if (targetClass.equals(class$java$lang$Double == null ? (class$java$lang$Double = NumberUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(number.doubleValue());
        }
        if (targetClass.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return BigInteger.valueOf(number.longValue());
        }
        if (targetClass.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Couldn't convert number [" + number + "] to target class [" + targetClass.getName() + "]");
    }

    public static Number parseNumber(String text, Class targetClass) {
        String trimmed = text.trim();
        if (targetClass.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.valueOf(trimmed);
        }
        if (targetClass.equals(class$java$lang$Short == null ? (class$java$lang$Short = NumberUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.valueOf(trimmed);
        }
        if (targetClass.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.valueOf(trimmed);
        }
        if (targetClass.equals(class$java$lang$Long == null ? (class$java$lang$Long = NumberUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.valueOf(trimmed);
        }
        if (targetClass.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return new BigInteger(trimmed);
        }
        if (targetClass.equals(class$java$lang$Float == null ? (class$java$lang$Float = NumberUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.valueOf(trimmed);
        }
        if (targetClass.equals(class$java$lang$Double == null ? (class$java$lang$Double = NumberUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.valueOf(trimmed);
        }
        if (targetClass.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert [" + trimmed + "] to target class [" + targetClass.getName() + "]");
    }

    public static Number parseNumber(String text, Class targetClass, NumberFormat numberFormat) {
        try {
            Number number = numberFormat.parse(text.trim());
            return NumberUtils.convertNumberToTargetClass(number, targetClass);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

