/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.springsource.loaded.FieldMember;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.TypeRegistry;
import sl.org.objectweb.asm.AnnotationVisitor;
import sl.org.objectweb.asm.Attribute;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.FieldVisitor;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;

public class TypeDescriptorExtractor {
    private static final boolean DEBUG_TYPE_DESCRIPTOR_EXTRACTOR = false;
    private TypeRegistry registry;

    public TypeDescriptorExtractor(TypeRegistry registry) {
        this.registry = registry;
    }

    public TypeDescriptor extract(byte[] bytes, boolean isReloadableType) {
        ClassReader fileReader = new ClassReader(bytes);
        ExtractionVisitor extractionVisitor = new ExtractionVisitor(isReloadableType);
        fileReader.accept(extractionVisitor, 0);
        return extractionVisitor.getTypeDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExtractionVisitor
    extends ClassVisitor
    implements Opcodes {
        private boolean isReloadableType;
        private int flags;
        private String typename;
        private String superclassName;
        private String[] interfaceNames;
        private boolean isGroovy;
        private boolean isEnum;
        private boolean hasClinit;
        private List<MethodMember> constructors;
        private List<MethodMember> methods;
        private List<FieldMember> fieldsRequiringAccessors;
        private List<FieldMember> fields;
        private List<String> finalInHierarchy;

        public ExtractionVisitor(boolean isReloadableType) {
            super(327680);
            this.isGroovy = false;
            this.isEnum = false;
            this.hasClinit = false;
            this.constructors = new ArrayList<MethodMember>();
            this.methods = new ArrayList<MethodMember>();
            this.fieldsRequiringAccessors = new ArrayList<FieldMember>();
            this.fields = new ArrayList<FieldMember>();
            this.finalInHierarchy = new ArrayList<String>();
            this.isReloadableType = isReloadableType;
        }

        public TypeDescriptor getTypeDescriptor() {
            if (this.isReloadableType) {
                this.computeCatchersAndSuperdispatchers();
            }
            this.computeFieldsRequiringAccessors();
            this.computeClashes();
            TypeDescriptor td = new TypeDescriptor(this.typename, this.superclassName, this.interfaceNames, this.flags, this.constructors, this.methods, this.fields, this.fieldsRequiringAccessors, this.isReloadableType, TypeDescriptorExtractor.this.registry, this.hasClinit, this.finalInHierarchy);
            if (this.isGroovy) {
                td.setIsGroovyType(true);
            }
            return td;
        }

        private void computeClashes() {
            String clashDescriptorPrefix = "(L" + this.typename + ";";
            for (MethodMember member : this.methods) {
                String desc;
                if (!member.isStatic() || !(desc = member.descriptor).startsWith(clashDescriptorPrefix)) continue;
                for (MethodMember member2 : this.methods) {
                    String staticParams;
                    if (!member2.name.equals(member.name)) continue;
                    String instanceParams = member2.descriptor;
                    if (!(instanceParams = instanceParams.substring(1, instanceParams.indexOf(41) + 1)).equals(staticParams = desc.substring(clashDescriptorPrefix.length(), desc.indexOf(41) + 1))) continue;
                    member.bits |= 2;
                }
            }
        }

        private TypeDescriptor getTypeDescriptorFor(String slashedname) {
            return TypeDescriptorExtractor.this.registry.getDescriptorFor(slashedname);
        }

        private TypeDescriptor findTypeDescriptor(TypeRegistry registry, String typename) {
            TypeRegistry regToTry = registry;
            TypeDescriptor td = regToTry.getDescriptorForReloadableType(typename);
            while (td == null && (regToTry = regToTry.getParentRegistry()) != null) {
                td = regToTry.getDescriptorForReloadableType(typename);
            }
            if (td == null) {
                td = this.getTypeDescriptorFor(typename);
            }
            return td;
        }

        private void walkHierarchyForCatchersAndSuperDispatchers(String superclass, List<String> superDispatchers, List<String> finalInHierarchy) {
            TypeDescriptor supertypeDescriptor = superclass == null ? null : this.findTypeDescriptor(TypeDescriptorExtractor.this.registry, superclass);
            boolean isReloadable = supertypeDescriptor.isReloadable();
            for (MethodMember method : supertypeDescriptor.getMethods()) {
                if (this.shouldCreateSuperDispatcherFor(method) && !superDispatchers.contains(method.nameAndDescriptor)) {
                    MethodMember superdispatcher = method.superDispatcherFor();
                    this.methods.add(superdispatcher);
                    superDispatchers.add(method.nameAndDescriptor);
                }
                if (this.shouldCatchMethod(method) && !finalInHierarchy.contains(method.getNameAndDescriptor())) {
                    if (!isReloadable && Modifier.isFinal(method.getModifiers())) {
                        finalInHierarchy.add(method.getNameAndDescriptor());
                        continue;
                    }
                    MethodMember found = null;
                    for (MethodMember existingMethod : this.methods) {
                        if (!existingMethod.equalsApartFromModifiers(method)) continue;
                        found = existingMethod;
                        break;
                    }
                    if (found != null) continue;
                    MethodMember catcherCopy = method.catcherCopyOf();
                    this.methods.add(catcherCopy);
                    continue;
                }
                if (!method.isFinal()) continue;
                finalInHierarchy.add(method.getNameAndDescriptor());
            }
            if (supertypeDescriptor.supertypeName != null) {
                this.walkHierarchyForCatchersAndSuperDispatchers(supertypeDescriptor.supertypeName, superDispatchers, finalInHierarchy);
            }
            if (Modifier.isAbstract(this.flags) && !this.isEnum) {
                for (String interfaceName : supertypeDescriptor.superinterfaceNames) {
                    this.addCatchersForNonImplementedMethodsFrom(interfaceName, finalInHierarchy);
                }
            }
        }

        private void computeCatchersAndSuperdispatchers() {
            if (Modifier.isInterface(this.flags)) {
                return;
            }
            ArrayList<String> doNotCatch = new ArrayList<String>();
            this.walkHierarchyForCatchersAndSuperDispatchers(this.superclassName, new ArrayList<String>(), doNotCatch);
            if (Modifier.isAbstract(this.flags) && !this.isEnum) {
                for (String interfaceName : this.interfaceNames) {
                    this.addCatchersForNonImplementedMethodsFrom(interfaceName, doNotCatch);
                }
            }
            this.finalInHierarchy.addAll(doNotCatch);
        }

        private boolean shouldCreateSuperDispatcherFor(MethodMember method) {
            return !(!method.isProtected() || method.getName().equals("finalize") && method.getDescriptor().equals("()V") || method.getName().equals("clone") && method.getDescriptor().equals("()Ljava/lang/Object;"));
        }

        private void addCatchersForNonImplementedMethodsFrom(String interfacename, List<String> finalInNonReloadableType) {
            TypeDescriptor interfaceDescriptor = this.findTypeDescriptor(TypeDescriptorExtractor.this.registry, interfacename);
            for (MethodMember method : interfaceDescriptor.getMethods()) {
                boolean found = false;
                for (MethodMember existingMethod : this.methods) {
                    if (!existingMethod.equalsApartFromModifiers(method)) continue;
                    found = true;
                    break;
                }
                if (found || finalInNonReloadableType.contains(method.getNameAndDescriptor())) continue;
                this.methods.add(method.catcherCopyOfWithAbstractRemoved());
            }
            for (String interfaceName : interfaceDescriptor.superinterfaceNames) {
                this.addCatchersForNonImplementedMethodsFrom(interfaceName, finalInNonReloadableType);
            }
        }

        private void computeFieldsRequiringAccessors() {
            String type = this.superclassName;
            while (type != null) {
                TypeDescriptor supertypeDescriptor = this.findTypeDescriptor(TypeDescriptorExtractor.this.registry, type);
                if (!supertypeDescriptor.isReloadable()) {
                    for (FieldMember field : supertypeDescriptor.getFields()) {
                        if (!field.isProtected()) continue;
                        boolean found = false;
                        for (FieldMember existingField : this.fields) {
                            if (!existingField.getName().equals(field.getName())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.fieldsRequiringAccessors.add(field);
                    }
                }
                type = supertypeDescriptor.supertypeName;
            }
        }

        private boolean shouldCatchMethod(MethodMember method) {
            return !method.isPrivateOrStaticOrFinal() && !method.getName().endsWith("_$superdispatcher$") && (!method.getName().equals("finalize") || !method.getDescriptor().equals("()V"));
        }

        @Override
        public void visit(int version, int flags, String name, String signature, String superclassName, String[] interfaceNames) {
            this.flags = flags;
            this.superclassName = superclassName;
            this.interfaceNames = interfaceNames;
            if (superclassName != null && superclassName.equals("java/lang/Enum")) {
                this.isEnum = true;
            }
            this.typename = name;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String classDesc, boolean isRuntime) {
            return null;
        }

        @Override
        public void visitAttribute(Attribute attribute) {
        }

        @Override
        public void visitInnerClass(String name, String outername, String innerName, int access) {
            if (name.equals(this.typename)) {
                this.flags = access;
            }
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.fields.add(new FieldMember(this.typename, access, name, desc, signature));
            if (name.equals("$callSiteArray")) {
                this.isGroovy = true;
            }
            return null;
        }

        @Override
        public MethodVisitor visitMethod(int flags, String name, String descriptor, String genericSignature, String[] exceptions) {
            if (name.charAt(0) != '<') {
                this.methods.add(new MethodMember(flags, name, descriptor, genericSignature, exceptions));
            } else if (name.equals("<init>")) {
                this.constructors.add(new MethodMember(flags, name, descriptor, genericSignature, exceptions));
            } else if (name.equals("<clinit>")) {
                this.hasClinit = true;
            }
            return null;
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
        }

        @Override
        public void visitSource(String source, String debug) {
        }

        @Override
        public void visitEnd() {
        }
    }
}

