/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.webflow.config.FlowElementAttribute;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.impl.SessionBindingConversationManager;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.engine.impl.FlowExecutionImplFactory;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;
import org.springframework.webflow.execution.repository.impl.DefaultFlowExecutionRepository;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.snapshot.SerializedFlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.snapshot.SimpleFlowExecutionSnapshotFactory;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;
import org.springframework.webflow.mvc.builder.MvcEnvironment;

class FlowExecutorFactoryBean
implements FactoryBean,
ApplicationContextAware,
BeanClassLoaderAware,
InitializingBean {
    private static final String ALWAYS_REDIRECT_ON_PAUSE = "alwaysRedirectOnPause";
    private FlowDefinitionLocator flowDefinitionLocator;
    private Integer maxFlowExecutions;
    private Integer maxFlowExecutionSnapshots;
    private Set flowExecutionAttributes;
    private FlowExecutionListenerLoader flowExecutionListenerLoader;
    private ConversionService conversionService;
    private FlowExecutor flowExecutor;
    private MvcEnvironment environment;
    private ClassLoader classLoader;

    FlowExecutorFactoryBean() {
    }

    public void setFlowDefinitionLocator(FlowDefinitionLocator flowDefinitionLocator) {
        this.flowDefinitionLocator = flowDefinitionLocator;
    }

    public void setMaxFlowExecutions(int maxFlowExecutions) {
        this.maxFlowExecutions = new Integer(maxFlowExecutions);
    }

    public void setMaxFlowExecutionSnapshots(int maxFlowExecutionSnapshots) {
        this.maxFlowExecutionSnapshots = new Integer(maxFlowExecutionSnapshots);
    }

    public void setFlowExecutionAttributes(Set flowExecutionAttributes) {
        this.flowExecutionAttributes = flowExecutionAttributes;
    }

    public void setFlowExecutionListenerLoader(FlowExecutionListenerLoader flowExecutionListenerLoader) {
        this.flowExecutionListenerLoader = flowExecutionListenerLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.environment = MvcEnvironment.environmentFor(applicationContext);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.flowDefinitionLocator, (String)"The flow definition locator property is required");
        if (this.conversionService == null) {
            this.conversionService = new DefaultConversionService();
        }
        MutableAttributeMap executionAttributes = this.createFlowExecutionAttributes();
        FlowExecutionImplFactory executionFactory = this.createFlowExecutionFactory(executionAttributes);
        DefaultFlowExecutionRepository executionRepository = this.createFlowExecutionRepository(executionFactory);
        executionFactory.setExecutionKeyFactory(executionRepository);
        this.flowExecutor = new FlowExecutorImpl(this.flowDefinitionLocator, executionFactory, executionRepository);
    }

    public Class getObjectType() {
        return FlowExecutor.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Object getObject() throws Exception {
        return this.flowExecutor;
    }

    private MutableAttributeMap createFlowExecutionAttributes() {
        LocalAttributeMap executionAttributes = new LocalAttributeMap();
        if (this.flowExecutionAttributes != null) {
            for (FlowElementAttribute attribute : this.flowExecutionAttributes) {
                executionAttributes.put(attribute.getName(), this.getConvertedValue(attribute));
            }
        }
        this.putDefaultFlowExecutionAttributes(executionAttributes);
        return executionAttributes;
    }

    private void putDefaultFlowExecutionAttributes(LocalAttributeMap executionAttributes) {
        if (!executionAttributes.contains(ALWAYS_REDIRECT_ON_PAUSE)) {
            if (this.environment == MvcEnvironment.PORTLET) {
                executionAttributes.put(ALWAYS_REDIRECT_ON_PAUSE, Boolean.FALSE);
            } else {
                executionAttributes.put(ALWAYS_REDIRECT_ON_PAUSE, Boolean.TRUE);
            }
        }
    }

    private DefaultFlowExecutionRepository createFlowExecutionRepository(FlowExecutionFactory executionFactory) {
        ConversationManager conversationManager = this.createConversationManager();
        FlowExecutionSnapshotFactory snapshotFactory = this.createFlowExecutionSnapshotFactory(executionFactory);
        DefaultFlowExecutionRepository rep = new DefaultFlowExecutionRepository(conversationManager, snapshotFactory);
        if (this.maxFlowExecutionSnapshots != null) {
            rep.setMaxSnapshots(this.maxFlowExecutionSnapshots);
        }
        return rep;
    }

    private ConversationManager createConversationManager() {
        SessionBindingConversationManager conversationManager = new SessionBindingConversationManager();
        if (this.maxFlowExecutions != null) {
            conversationManager.setMaxConversations(this.maxFlowExecutions);
        }
        return conversationManager;
    }

    private FlowExecutionSnapshotFactory createFlowExecutionSnapshotFactory(FlowExecutionFactory executionFactory) {
        if (this.maxFlowExecutionSnapshots != null && this.maxFlowExecutionSnapshots == 0) {
            this.maxFlowExecutionSnapshots = new Integer(1);
            return new SimpleFlowExecutionSnapshotFactory(executionFactory, this.flowDefinitionLocator);
        }
        return new SerializedFlowExecutionSnapshotFactory(executionFactory, this.flowDefinitionLocator);
    }

    private FlowExecutionImplFactory createFlowExecutionFactory(AttributeMap executionAttributes) {
        FlowExecutionImplFactory executionFactory = new FlowExecutionImplFactory();
        executionFactory.setExecutionAttributes(executionAttributes);
        if (this.flowExecutionListenerLoader != null) {
            executionFactory.setExecutionListenerLoader(this.flowExecutionListenerLoader);
        }
        return executionFactory;
    }

    private Object getConvertedValue(FlowElementAttribute attribute) {
        if (attribute.needsTypeConversion()) {
            Class targetType = this.fromStringToClass(attribute.getType());
            ConversionExecutor converter = this.conversionService.getConversionExecutor(String.class, targetType);
            return converter.execute((Object)attribute.getValue());
        }
        return attribute.getValue();
    }

    private Class fromStringToClass(String name) {
        Class clazz = this.conversionService.getClassForAlias(name);
        if (clazz != null) {
            return clazz;
        }
        try {
            return ClassUtils.forName((String)name, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Unable to load class '" + name + "'");
        }
    }
}

