/*
 * 使用本软件请从杭州钛特云有限公司获取授权，其它途径获取本软件的行为皆为侵权行为
 * 本源代码由杭州钛特云科技有限公司授权给江苏南大先腾信息产业股份有限公司使用
 */
/**
 * Copyright (c) 2011-2019, James Zhan 詹波 (jfinal@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.tio.jfinal.kit;

import org.tio.jfinal.template.Directive;
import org.tio.jfinal.template.Engine;
import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.Template;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.Scope;

import java.util.Map;

/**
 * EL 表达式语言求值工具类
 *
 * <pre>
 * 1：不带参示例
 * 	  Integer value = ElKit.eval("1 + 2 * 3");
 *
 * 2：带参示例
 * 	  Kv data = Kv.by("a", 2).set("b", 3);
 * 	  Integer value = ElKit.eval("1 + a * b", data);
 * </pre>
 */
public class ElKit {

	private static Engine engine = new Engine();
	private static final String RETURN_VALUE_KEY = "_RETURN_VALUE_";

	static {
		engine.addDirective("eval", InnerEvalDirective.class);
	}

	public static Engine getEngine() {
		return engine;
	}

	public static <T> T eval(String expr) {
		return eval(expr, Kv.create());
	}

	@SuppressWarnings("unchecked")
	public static <T> T eval(String expr, Map<?, ?> data) {
		String stringTemplate = "#eval(" + expr + ")";
		Template template = engine.getTemplateByString(stringTemplate);
		template.render(data, (java.io.Writer)null);
		return (T)data.get(RETURN_VALUE_KEY);
	}

	public static class InnerEvalDirective extends Directive {
		public void exec(Env env, Scope scope, Writer writer) {
			Object value = exprList.eval(scope);
			scope.set(RETURN_VALUE_KEY, value);
		}
	}
}




