/*
 * 使用本软件请从杭州钛特云有限公司获取授权，其它途径获取本软件的行为皆为侵权行为
 * 本源代码由杭州钛特云科技有限公司授权给江苏南大先腾信息产业股份有限公司使用
 */
/**
 *
 */
package org.tio.jfinal.plugin.activerecord.sql.proxy;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.*;
import java.util.*;

/**
 * @author tanyaowu
 *
 */
public class ProxyPreparedStatement implements PreparedStatement {

	PreparedStatement ps = null;

	//	public static final Logger querysqlLog = LoggerFactory.getLogger("querysqlLog");
	//
	//	public static final Logger slowsqlLog = LoggerFactory.getLogger("slowsqlLog");
	//
	//	public static final Logger updatesqlLog = LoggerFactory.getLogger("updatesqlLog");

	static final String OTHER_TAG = "other_";

	static final String NULL = "null";

	Map<Integer, Object> params = new HashMap<>();
	List<Map<Integer, Object>> paramsList = new ArrayList<>();

	String sql = null;
	List<String> sqlList = new ArrayList<>();

	/**
	 *
	 */
	public ProxyPreparedStatement(PreparedStatement ps, String sql) {
		this.ps = ps;
		this.sql = sql;
	}

	@Override
	public void addBatch() throws SQLException {
		paramsList.add(params);
		params = new HashMap<>();
		ps.addBatch();
	}

	@Override
	public void addBatch(String sql) throws SQLException {
		sqlList.add(sql);
		ps.addBatch(sql);
	}

	@Override
	public void cancel() throws SQLException {

		ps.cancel();
	}

	@Override
	public void clearBatch() throws SQLException {

		ps.clearBatch();
	}

	@Override
	public void clearParameters() throws SQLException {

		ps.clearParameters();
	}

	@Override
	public void clearWarnings() throws SQLException {

		ps.clearWarnings();
	}

	@Override
	public void close() throws SQLException {

		ps.close();
	}

	@Override
	public void closeOnCompletion() throws SQLException {

		ps.closeOnCompletion();
	}

	@Override
	public boolean execute() throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.execute();
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public boolean execute(String sql) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.execute(sql);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.execute(sql, autoGeneratedKeys);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public boolean execute(String sql, int[] columnIndexes) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.execute(sql, columnIndexes);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public boolean execute(String sql, String[] columnNames) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.execute(sql, columnNames);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public int[] executeBatch() throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeBatch();
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logBatch(this, cost, e);
		}
	}

	@Override
	public long[] executeLargeBatch() throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeLargeBatch();
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logBatch(this, cost, e);
		}
	}

	@Override
	public long executeLargeUpdate() throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeLargeUpdate();
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(null, this, cost, e);
		}
	}

	@Override
	public long executeLargeUpdate(String sql) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeLargeUpdate(sql);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeLargeUpdate(sql, autoGeneratedKeys);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeLargeUpdate(sql, columnIndexes);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeLargeUpdate(sql, columnNames);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public ResultSet executeQuery() throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeQuery();
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logQuery(sql, this, cost, e);
		}
	}

	@Override
	public ResultSet executeQuery(String sql) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeQuery(sql);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logQuery(sql, this, cost, e);
		}
	}

	@Override
	public int executeUpdate() throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeUpdate();
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public int executeUpdate(String sql) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeUpdate(sql);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeUpdate(sql, autoGeneratedKeys);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeUpdate(sql, columnIndexes);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public int executeUpdate(String sql, String[] columnNames) throws SQLException {
		Throwable e = null;
		long start = System.currentTimeMillis();
		try {
			return ps.executeUpdate(sql, columnNames);
		} catch (Throwable t) {
			e = t;
			throw t;
		} finally {
			long end = System.currentTimeMillis();
			long cost = end - start;
			SqlLog.logUpdate(sql, this, cost, e);
		}
	}

	@Override
	public Connection getConnection() throws SQLException {

		return ps.getConnection();
	}

	@Override
	public int getFetchDirection() throws SQLException {

		return ps.getFetchDirection();
	}

	@Override
	public int getFetchSize() throws SQLException {

		return ps.getFetchSize();
	}

	@Override
	public ResultSet getGeneratedKeys() throws SQLException {

		return ps.getGeneratedKeys();
	}

	@Override
	public long getLargeMaxRows() throws SQLException {

		return ps.getLargeMaxRows();
	}

	@Override
	public long getLargeUpdateCount() throws SQLException {

		return ps.getLargeUpdateCount();
	}

	@Override
	public int getMaxFieldSize() throws SQLException {

		return ps.getMaxFieldSize();
	}

	@Override
	public int getMaxRows() throws SQLException {

		return ps.getMaxRows();
	}

	@Override
	public ResultSetMetaData getMetaData() throws SQLException {

		return ps.getMetaData();
	}

	@Override
	public boolean getMoreResults() throws SQLException {

		return ps.getMoreResults();
	}

	@Override
	public boolean getMoreResults(int current) throws SQLException {

		return ps.getMoreResults(current);
	}

	@Override
	public ParameterMetaData getParameterMetaData() throws SQLException {

		return ps.getParameterMetaData();
	}

	@Override
	public int getQueryTimeout() throws SQLException {

		return ps.getQueryTimeout();
	}

	@Override
	public ResultSet getResultSet() throws SQLException {

		return ps.getResultSet();
	}

	@Override
	public int getResultSetConcurrency() throws SQLException {

		return ps.getResultSetConcurrency();
	}

	@Override
	public int getResultSetHoldability() throws SQLException {

		return ps.getResultSetHoldability();
	}

	@Override
	public int getResultSetType() throws SQLException {

		return ps.getResultSetType();
	}

	@Override
	public int getUpdateCount() throws SQLException {

		return ps.getUpdateCount();
	}

	@Override
	public SQLWarning getWarnings() throws SQLException {

		return ps.getWarnings();
	}

	@Override
	public boolean isClosed() throws SQLException {

		return ps.isClosed();
	}

	@Override
	public boolean isCloseOnCompletion() throws SQLException {

		return ps.isCloseOnCompletion();
	}

	@Override
	public boolean isPoolable() throws SQLException {

		return ps.isPoolable();
	}

	@Override
	public boolean isWrapperFor(Class<?> iface) throws SQLException {

		return ps.isWrapperFor(iface);
	}

	@Override
	public void setArray(int parameterIndex, Array x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setArray(parameterIndex, x);
	}

	@Override
	public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setAsciiStream(parameterIndex, x);
	}

	@Override
	public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
		params.put(parameterIndex, x);
		ps.setAsciiStream(parameterIndex, x, length);
	}

	@Override
	public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
		params.put(parameterIndex, x);
		ps.setAsciiStream(parameterIndex, x, length);
	}

	@Override
	public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setBigDecimal(parameterIndex, x);
	}

	@Override
	public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setBinaryStream(parameterIndex, x);
	}

	@Override
	public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
		params.put(parameterIndex, x);
		ps.setBinaryStream(parameterIndex, x, length);
	}

	@Override
	public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
		params.put(parameterIndex, x);
		ps.setBinaryStream(parameterIndex, x, length);
	}

	@Override
	public void setBlob(int parameterIndex, Blob x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setBlob(parameterIndex, x);
	}

	@Override
	public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "inputStream");
		ps.setBlob(parameterIndex, inputStream);
	}

	@Override
	public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "inputStream");
		ps.setBlob(parameterIndex, inputStream, length);
	}

	@Override
	public void setBoolean(int parameterIndex, boolean x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setBoolean(parameterIndex, x);
	}

	@Override
	public void setByte(int parameterIndex, byte x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setByte(parameterIndex, x);
	}

	@Override
	public void setBytes(int parameterIndex, byte[] x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setBytes(parameterIndex, x);
	}

	@Override
	public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "reader");
		ps.setCharacterStream(parameterIndex, reader);
	}

	@Override
	public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "reader");
		ps.setCharacterStream(parameterIndex, reader, length);
	}

	@Override
	public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "reader");
		ps.setCharacterStream(parameterIndex, reader, length);
	}

	@Override
	public void setClob(int parameterIndex, Clob x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setClob(parameterIndex, x);
	}

	@Override
	public void setClob(int parameterIndex, Reader reader) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "reader");
		ps.setClob(parameterIndex, reader);
	}

	@Override
	public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "reader");
		ps.setClob(parameterIndex, reader, length);
	}

	@Override
	public void setCursorName(String name) throws SQLException {

		ps.setCursorName(name);
	}

	@Override
	public void setDate(int parameterIndex, Date x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setDate(parameterIndex, x);
	}

	@Override
	public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
		params.put(parameterIndex, x);
		ps.setDate(parameterIndex, x, cal);
	}

	@Override
	public void setDouble(int parameterIndex, double x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setDouble(parameterIndex, x);
	}

	@Override
	public void setEscapeProcessing(boolean enable) throws SQLException {

		ps.setEscapeProcessing(enable);
	}

	@Override
	public void setFetchDirection(int direction) throws SQLException {

		ps.setFetchDirection(direction);
	}

	@Override
	public void setFetchSize(int rows) throws SQLException {

		ps.setFetchSize(rows);
	}

	@Override
	public void setFloat(int parameterIndex, float x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setFloat(parameterIndex, x);
	}

	@Override
	public void setInt(int parameterIndex, int x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setInt(parameterIndex, x);
	}

	@Override
	public void setLargeMaxRows(long max) throws SQLException {

		ps.setLargeMaxRows(max);
	}

	@Override
	public void setLong(int parameterIndex, long x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setLong(parameterIndex, x);
	}

	@Override
	public void setMaxFieldSize(int max) throws SQLException {

		ps.setMaxFieldSize(max);
	}

	@Override
	public void setMaxRows(int max) throws SQLException {

		ps.setMaxRows(max);
	}

	@Override
	public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "reader");
		ps.setNCharacterStream(parameterIndex, value);
	}

	@Override
	public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "reader");
		ps.setNCharacterStream(parameterIndex, value, length);
	}

	@Override
	public void setNClob(int parameterIndex, NClob value) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "NClob");
		ps.setNClob(parameterIndex, value);
	}

	@Override
	public void setNClob(int parameterIndex, Reader reader) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "reader");
		ps.setNClob(parameterIndex, reader);
	}

	@Override
	public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "reader");
		ps.setNClob(parameterIndex, reader, length);
	}

	@Override
	public void setNString(int parameterIndex, String value) throws SQLException {
		params.put(parameterIndex, value);
		ps.setNString(parameterIndex, value);
	}

	@Override
	public void setNull(int parameterIndex, int sqlType) throws SQLException {
		params.put(parameterIndex, NULL);
		ps.setNull(parameterIndex, sqlType);
	}

	@Override
	public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
		params.put(parameterIndex, NULL);
		ps.setNull(parameterIndex, sqlType, typeName);
	}

	@Override
	public void setObject(int parameterIndex, Object x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setObject(parameterIndex, x);
	}

	@Override
	public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
		params.put(parameterIndex, x);
		ps.setObject(parameterIndex, x, targetSqlType);
	}

	@Override
	public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
		params.put(parameterIndex, x);
		ps.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
	}

	@Override
	public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
		params.put(parameterIndex, x);
		ps.setObject(parameterIndex, x, targetSqlType);
	}

	@Override
	public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
		params.put(parameterIndex, x);
		ps.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
	}

	@Override
	public void setPoolable(boolean poolable) throws SQLException {

		ps.setPoolable(poolable);
	}

	@Override
	public void setQueryTimeout(int seconds) throws SQLException {

		ps.setQueryTimeout(seconds);
	}

	@Override
	public void setRef(int parameterIndex, Ref x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setRef(parameterIndex, x);
	}

	@Override
	public void setRowId(int parameterIndex, RowId x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setRowId(parameterIndex, x);
	}

	@Override
	public void setShort(int parameterIndex, short x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setShort(parameterIndex, x);
	}

	@Override
	public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
		params.put(parameterIndex, OTHER_TAG + "SQLXML");
		ps.setSQLXML(parameterIndex, xmlObject);
	}

	@Override
	public void setString(int parameterIndex, String x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setString(parameterIndex, x);
	}

	@Override
	public void setTime(int parameterIndex, Time x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setTime(parameterIndex, x);
	}

	@Override
	public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
		params.put(parameterIndex, x);
		ps.setTime(parameterIndex, x, cal);
	}

	@Override
	public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setTimestamp(parameterIndex, x);
	}

	@Override
	public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
		params.put(parameterIndex, x);
		ps.setTimestamp(parameterIndex, x, cal);
	}

	@Deprecated
	@Override
	public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
		params.put(parameterIndex, x);
		ps.setUnicodeStream(parameterIndex, x, length);
	}

	@Override
	public void setURL(int parameterIndex, URL x) throws SQLException {
		params.put(parameterIndex, x);
		ps.setURL(parameterIndex, x);
	}

	@Override
	public String toString() {
		return getClass().getName() + "@" + Integer.toHexString(hashCode());
	}

	@Override
	public <T> T unwrap(Class<T> iface) throws SQLException {

		return ps.unwrap(iface);
	}

}
