/*
 * 使用本软件请从杭州钛特云有限公司获取授权，其它途径获取本软件的行为皆为侵权行为
 * 本源代码由杭州钛特云科技有限公司授权给江苏南大先腾信息产业股份有限公司使用
 */
/**
 * Copyright (c) 2011-2019, James Zhan 詹波 (jfinal@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.tio.jfinal.template.ext.directive;

import org.tio.jfinal.template.Directive;
import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;

import java.io.IOException;

/**
 * Escape 对字符串进行转义
 * 用法:
 * #escape(value)
 */
public class EscapeDirective extends Directive {

	public void exec(Env env, Scope scope, Writer writer) {
		try {
			Object value = exprList.eval(scope);

			if (value instanceof String) {
				escape((String)value, writer);
			} else if (value instanceof Number) {
				Class<?> c = value.getClass();
				if (c == Integer.class) {
					writer.write((Integer)value);
				} else if (c == Long.class) {
					writer.write((Long)value);
				} else if (c == Double.class) {
					writer.write((Double)value);
				} else if (c == Float.class) {
					writer.write((Float)value);
				} else if (c == Short.class) {
					writer.write((Short)value);
				} else {
					writer.write(value.toString());
				}
			} else if (value != null) {
				escape(value.toString(), writer);
			}
		} catch(TemplateException | ParseException e) {
			throw e;
		} catch(Exception e) {
			throw new TemplateException(e.getMessage(), location, e);
		}
	}

	private void escape(String str, Writer w) throws IOException {
		for (int i = 0, len = str.length(); i < len; i++) {
			char cur = str.charAt(i);
			switch (cur) {
			case '<':
				w.write("&lt;");
				break;
			case '>':
				w.write("&gt;");
				break;
			case '"':
				w.write("&quot;");
				break;
			case '\'':
				// w.write("&apos;");	// IE 不支持 &apos; 考虑 &#39;
				w.write("&#39;");
				break;
			case '&':
				w.write("&amp;");
				break;
			default:
				w.write(str, i, 1);
				break;
			}
		}
	}
}
