/*
 * 使用本软件请从杭州钛特云有限公司获取授权，其它途径获取本软件的行为皆为侵权行为
 * 本源代码由杭州钛特云科技有限公司授权给江苏南大先腾信息产业股份有限公司使用
 */
/**
 * Copyright (c) 2011-2019, James Zhan 詹波 (jfinal@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.tio.jfinal.template.io;

import java.io.IOException;

/**
 * FloatingWriter
 */
public class FloatingWriter {
	
	public static void write(ByteWriter byteWriter, double doubleValue) throws IOException {
		FloatingDecimal fd = new FloatingDecimal(doubleValue);
		char[] chars = byteWriter.chars;
		byte[] bytes = byteWriter.bytes;
		int len = fd.getChars(chars);
		for (int i=0; i<len; i++) {
			bytes[i] = (byte)chars[i];
		}
		byteWriter.out.write(bytes, 0, len);
	}
	
	public static void write(ByteWriter byteWriter, float floatValue) throws IOException {
		FloatingDecimal fd = new FloatingDecimal(floatValue);
		char[] chars = byteWriter.chars;
		byte[] bytes = byteWriter.bytes;
		int len = fd.getChars(chars);
		for (int i=0; i<len; i++) {
			bytes[i] = (byte)chars[i];
		}
		byteWriter.out.write(bytes, 0, len);
	}
	
	public static void write(CharWriter charWriter, double doubleValue) throws IOException {
		FloatingDecimal fd = new FloatingDecimal(doubleValue);
		char[] chars = charWriter.chars;
		int len = fd.getChars(chars);
		charWriter.out.write(chars, 0, len);
	}
	
	public static void write(CharWriter charWriter, float floatValue) throws IOException {
		FloatingDecimal fd = new FloatingDecimal(floatValue);
		char[] chars = charWriter.chars;
		int len = fd.getChars(chars);
		charWriter.out.write(chars, 0, len);
	}
}






